/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.engine.rust;

import ai.djl.BaseModel;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.engine.rust.RsNDManager;
import ai.djl.engine.rust.RsSymbolBlock;
import ai.djl.engine.rust.RustLibrary;
import ai.djl.ndarray.types.DataType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class RsModel
extends BaseModel {
    private final AtomicReference<Long> handle;

    RsModel(String name, Device device) {
        super(name);
        this.manager = RsNDManager.getSystemManager().newSubManager(device);
        this.manager.setName("RsModel");
        this.dataType = DataType.FLOAT16;
        this.handle = new AtomicReference();
    }

    @Override
    public void load(Path modelPath, String prefix, Map<String, ?> options) throws IOException, MalformedModelException {
        if (Files.notExists(modelPath, new LinkOption[0])) {
            throw new FileNotFoundException("Model directory doesn't exist: " + modelPath.toAbsolutePath());
        }
        this.setModelDir(modelPath);
        if (this.block == null) {
            Device device = this.manager.getDevice();
            this.handle.set(RustLibrary.loadModel(this.modelDir.toAbsolutePath().toString(), this.dataType.ordinal(), device.getDeviceType(), device.getDeviceId()));
            this.block = new RsSymbolBlock((RsNDManager)this.manager, this.handle.get());
        } else {
            this.loadBlock(prefix, options);
        }
    }

    @Override
    public void close() {
        Long pointer = this.handle.getAndSet(null);
        if (pointer != null) {
            RustLibrary.deleteModel(pointer);
        }
        super.close();
    }
}

