/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.modality.Classifications;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class FillMaskTranslator
implements Translator<String, Classifications> {
    private HuggingFaceTokenizer tokenizer;
    private String maskToken;
    private long maskTokenId;
    private int topK;
    private boolean includeTokenTypes;
    private boolean int32;
    private Batchifier batchifier;

    FillMaskTranslator(HuggingFaceTokenizer tokenizer, String maskToken, int topK, boolean includeTokenTypes, boolean int32, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.maskToken = maskToken;
        this.topK = topK;
        this.includeTokenTypes = includeTokenTypes;
        this.int32 = int32;
        this.batchifier = batchifier;
        Encoding encoding = tokenizer.encode(maskToken, false, false);
        this.maskTokenId = encoding.getIds()[0];
    }

    @Override
    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    @Override
    public NDList processInput(TranslatorContext ctx, String input) throws TranslateException {
        Encoding encoding = this.tokenizer.encode(input);
        long[] indices = encoding.getIds();
        int maskIndex = this.getMaskIndex(indices);
        ctx.setAttachment("maskIndex", maskIndex);
        return encoding.toNDList(ctx.getNDManager(), this.includeTokenTypes, this.int32);
    }

    @Override
    public NDList batchProcessInput(TranslatorContext ctx, List<String> inputs) throws TranslateException {
        NDManager manager = ctx.getNDManager();
        Encoding[] encodings = this.tokenizer.batchEncode(inputs);
        NDList[] batch = new NDList[encodings.length];
        int[] maskIndices = new int[encodings.length];
        ctx.setAttachment("maskIndices", maskIndices);
        for (int i = 0; i < batch.length; ++i) {
            long[] indices = encodings[i].getIds();
            maskIndices[i] = this.getMaskIndex(indices);
            batch[i] = encodings[i].toNDList(manager, this.includeTokenTypes, this.int32);
        }
        return this.batchifier.batchify(batch);
    }

    @Override
    public Classifications processOutput(TranslatorContext ctx, NDList list) {
        int maskIndex = (Integer)ctx.getAttachment("maskIndex");
        return this.toClassifications(list, maskIndex);
    }

    @Override
    public List<Classifications> batchProcessOutput(TranslatorContext ctx, NDList list) {
        NDList[] batch = this.batchifier.unbatchify(list);
        int[] maskIndices = (int[])ctx.getAttachment("maskIndices");
        ArrayList<Classifications> ret = new ArrayList<Classifications>(maskIndices.length);
        for (int i = 0; i < batch.length; ++i) {
            ret.add(this.toClassifications(batch[i], maskIndices[i]));
        }
        return ret;
    }

    private int getMaskIndex(long[] indices) throws TranslateException {
        int maskIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] != this.maskTokenId) continue;
            if (maskIndex != -1) {
                throw new TranslateException("Only one mask supported.");
            }
            maskIndex = i;
        }
        if (maskIndex == -1) {
            throw new TranslateException("Mask token " + this.maskToken + " not found.");
        }
        return maskIndex;
    }

    private Classifications toClassifications(NDList output, int maskIndex) {
        NDArray prob = ((NDArray)output.get(0)).get(maskIndex).softmax(0);
        NDArray array = prob.argSort(0, false);
        long[] classIds = new long[this.topK];
        ArrayList<Double> probabilities = new ArrayList<Double>(this.topK);
        for (int i = 0; i < this.topK; ++i) {
            classIds[i] = array.getLong(i);
            probabilities.add(Double.valueOf(prob.getFloat(classIds[i])));
        }
        String[] classes = this.tokenizer.decode(classIds).trim().split(" ");
        return new Classifications(Arrays.asList(classes), probabilities);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = FillMaskTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private String maskedToken = "[MASK]";
        private int topK = 5;
        private boolean includeTokenTypes;
        private boolean int32;
        private Batchifier batchifier = Batchifier.STACK;

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optMaskToken(String maskedToken) {
            this.maskedToken = maskedToken;
            return this;
        }

        public Builder optTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder optIncludeTokenTypes(boolean includeTokenTypes) {
            this.includeTokenTypes = includeTokenTypes;
            return this;
        }

        public Builder optInt32(boolean int32) {
            this.int32 = int32;
            return this;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            this.optMaskToken(ArgumentsUtil.stringValue(arguments, "maskToken", "[MASK]"));
            this.optInt32(ArgumentsUtil.booleanValue(arguments, "int32"));
            this.optTopK(ArgumentsUtil.intValue(arguments, "topK", 5));
            this.optIncludeTokenTypes(ArgumentsUtil.booleanValue(arguments, "includeTokenTypes"));
            String batchifierStr = ArgumentsUtil.stringValue(arguments, "batchifier", "stack");
            this.optBatchifier(Batchifier.fromString(batchifierStr));
        }

        public FillMaskTranslator build() throws IOException {
            return new FillMaskTranslator(this.tokenizer, this.maskedToken, this.topK, this.includeTokenTypes, this.int32, this.batchifier);
        }
    }
}

