/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TextEmbeddingTranslator
implements Translator<String, float[]> {
    private static final int[] AXIS = new int[]{-2};
    private HuggingFaceTokenizer tokenizer;
    private Batchifier batchifier;
    private boolean normalize;
    private String pooling;
    private boolean includeTokenTypes;
    private boolean int32;
    private String dense;
    private String denseActivation;
    private String layerNorm;
    private NDList denseModel;
    private NDList layerNormModel;

    TextEmbeddingTranslator(HuggingFaceTokenizer tokenizer, Batchifier batchifier, String pooling, boolean normalize, boolean includeTokenTypes, boolean int32, String dense, String denseActivation, String layerNorm) {
        this.tokenizer = tokenizer;
        this.batchifier = batchifier;
        this.pooling = pooling;
        this.normalize = normalize;
        this.includeTokenTypes = includeTokenTypes;
        this.int32 = int32;
        this.dense = dense;
        this.denseActivation = denseActivation;
        this.layerNorm = layerNorm;
    }

    @Override
    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        InputStream is;
        Path file;
        NDManager manager = ctx.getPredictorManager().newSubManager();
        if (this.dense != null) {
            file = Paths.get(this.dense, new String[0]);
            if (!file.isAbsolute()) {
                file = ctx.getModel().getModelPath().resolve(file);
            }
            if (Files.exists(file, new LinkOption[0])) {
                is = Files.newInputStream(file, new OpenOption[0]);
                try {
                    this.denseModel = NDList.decode(manager, is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
        if (this.layerNorm != null) {
            file = Paths.get(this.layerNorm, new String[0]);
            if (!file.isAbsolute()) {
                file = ctx.getModel().getModelPath().resolve(file);
            }
            if (Files.exists(file, new LinkOption[0])) {
                is = Files.newInputStream(file, new OpenOption[0]);
                try {
                    this.layerNormModel = NDList.decode(manager, is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
    }

    @Override
    public NDList processInput(TranslatorContext ctx, String input) {
        NDManager manager = ctx.getNDManager();
        Encoding encoding = this.tokenizer.encode(input);
        NDList list = encoding.toNDList(manager, this.includeTokenTypes, this.int32);
        ctx.setAttachment("attentionMask", list.get(1));
        return list;
    }

    @Override
    public NDList batchProcessInput(TranslatorContext ctx, List<String> inputs) {
        NDManager manager = ctx.getNDManager();
        Encoding[] encodings = this.tokenizer.batchEncode(inputs);
        NDList list = Encoding.toNDList(encodings, manager, this.includeTokenTypes, this.int32);
        ctx.setAttachment("attentionMask", list.get(1));
        return list;
    }

    @Override
    public float[] processOutput(TranslatorContext ctx, NDList list) {
        NDArray inputAttentionMask = (NDArray)ctx.getAttachment("attentionMask");
        NDArray embeddings = this.processEmbedding(list, inputAttentionMask);
        return embeddings.toFloatArray();
    }

    @Override
    public List<float[]> batchProcessOutput(TranslatorContext ctx, NDList list) {
        NDArray attentionMask = (NDArray)ctx.getAttachment("attentionMask");
        NDArray output = this.processEmbedding(list, attentionMask);
        int batchSize = Math.toIntExact(output.size(0));
        float[] buf = output.toFloatArray();
        if (batchSize == 1) {
            return Collections.singletonList(buf);
        }
        int length = buf.length / batchSize;
        ArrayList<float[]> ret = new ArrayList<float[]>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            float[] f = new float[length];
            System.arraycopy(buf, i * length, f, 0, length);
            ret.add(f);
        }
        return ret;
    }

    private NDArray processEmbedding(NDList list, NDArray attentionMask) {
        NDArray weight;
        NDArray embedding = list.get("last_hidden_state");
        if (embedding == null) {
            embedding = list.head();
        }
        switch (this.pooling) {
            case "mean": {
                embedding = TextEmbeddingTranslator.meanPool(embedding, attentionMask, false);
                break;
            }
            case "mean_sqrt_len": {
                embedding = TextEmbeddingTranslator.meanPool(embedding, attentionMask, true);
                break;
            }
            case "max": {
                embedding = TextEmbeddingTranslator.maxPool(embedding, attentionMask);
                break;
            }
            case "weightedmean": {
                embedding = TextEmbeddingTranslator.weightedMeanPool(embedding, attentionMask);
                break;
            }
            case "cls": {
                embedding = embedding.get(new NDIndex(":, 0", new Object[0]));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected pooling mode: " + this.pooling));
            }
        }
        if (this.denseModel != null) {
            weight = this.denseModel.get("linear.weight");
            NDArray bias = this.denseModel.get("linear.bias");
            embedding = (NDArray)embedding.getNDArrayInternal().linear(embedding, weight, bias).get(0);
            if ("Tanh".equalsIgnoreCase(this.denseActivation)) {
                embedding = embedding.tanh();
            }
        }
        if (this.layerNormModel != null) {
            weight = this.layerNormModel.get("norm.weight");
            NDArray bias = this.layerNormModel.get("norm.bias");
            Shape shape = weight.getShape();
            embedding = (NDArray)embedding.getNDArrayInternal().layerNorm(embedding, shape, weight, bias, 1.0E-5f).get(0);
        }
        if (this.normalize) {
            embedding = embedding.normalize(2.0, -1L);
        }
        return embedding;
    }

    private static NDArray meanPool(NDArray embeddings, NDArray attentionMask, boolean sqrt) {
        long[] shape = embeddings.getShape().getShape();
        attentionMask = attentionMask.expandDims(-1).broadcast(shape);
        NDArray inputAttentionMaskSum = attentionMask.sum(AXIS);
        NDArray clamp = inputAttentionMaskSum.clip(Float.valueOf(1.0E-9f), Float.valueOf(1.0E12f));
        NDArray prod = embeddings.mul(attentionMask);
        NDArray sum = prod.sum(AXIS);
        if (sqrt) {
            return sum.div(clamp.sqrt());
        }
        return sum.div(clamp);
    }

    private static NDArray maxPool(NDArray embeddings, NDArray inputAttentionMask) {
        long[] shape = embeddings.getShape().getShape();
        inputAttentionMask = inputAttentionMask.expandDims(-1).broadcast(shape);
        inputAttentionMask = inputAttentionMask.eq(0);
        embeddings = embeddings.duplicate();
        embeddings.set(inputAttentionMask, (Number)-1.0E9);
        return embeddings.max(AXIS, false);
    }

    private static NDArray weightedMeanPool(NDArray embeddings, NDArray attentionMask) {
        long[] shape = embeddings.getShape().getShape();
        NDArray weight = embeddings.getManager().arange(1.0f, shape[0] + 1L);
        weight = weight.expandDims(-1).broadcast(shape);
        attentionMask = attentionMask.expandDims(-1).broadcast(shape).mul(weight);
        NDArray maskSum = attentionMask.sum(AXIS);
        NDArray embeddingSum = embeddings.mul(attentionMask).sum(AXIS);
        return embeddingSum.div(maskSum);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = TextEmbeddingTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private Batchifier batchifier = Batchifier.STACK;
        private boolean normalize = true;
        private String pooling = "mean";
        private boolean includeTokenTypes;
        private boolean int32;
        private String dense;
        private String denseActivation;
        private String layerNorm;

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public Builder optNormalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public Builder optPoolingMode(String poolingMode) {
            if (!("mean".equals(poolingMode) || "max".equals(poolingMode) || "cls".equals(poolingMode) || "mean_sqrt_len".equals(poolingMode) || "weightedmean".equals(poolingMode))) {
                throw new IllegalArgumentException("Invalid pooling model, must be one of [mean, max, cls, mean_sqrt_len, weightedmean].");
            }
            this.pooling = poolingMode;
            return this;
        }

        public Builder optIncludeTokenTypes(boolean includeTokenTypes) {
            this.includeTokenTypes = includeTokenTypes;
            return this;
        }

        public Builder optInt32(boolean int32) {
            this.int32 = int32;
            return this;
        }

        public Builder optDense(String dense) {
            this.dense = dense;
            return this;
        }

        public Builder optDenseActivation(String denseActivation) {
            this.denseActivation = denseActivation;
            return this;
        }

        public Builder optLayerNorm(String layerNorm) {
            this.layerNorm = layerNorm;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            String batchifierStr = ArgumentsUtil.stringValue(arguments, "batchifier", "stack");
            this.optBatchifier(Batchifier.fromString(batchifierStr));
            this.optNormalize(ArgumentsUtil.booleanValue(arguments, "normalize", true));
            this.optPoolingMode(ArgumentsUtil.stringValue(arguments, "pooling", "mean"));
            this.optIncludeTokenTypes(ArgumentsUtil.booleanValue(arguments, "includeTokenTypes"));
            this.optInt32(ArgumentsUtil.booleanValue(arguments, "int32"));
            this.optDense(ArgumentsUtil.stringValue(arguments, "dense"));
            this.optDenseActivation(ArgumentsUtil.stringValue(arguments, "denseActivation"));
            this.optLayerNorm(ArgumentsUtil.stringValue(arguments, "layerNorm"));
        }

        public TextEmbeddingTranslator build() throws IOException {
            return new TextEmbeddingTranslator(this.tokenizer, this.batchifier, this.pooling, this.normalize, this.includeTokenTypes, this.int32, this.dense, this.denseActivation, this.layerNorm);
        }
    }
}

