/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.Model;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.ZeroShotClassificationTranslator;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.nlp.translator.ZeroShotClassificationInput;
import ai.djl.modality.nlp.translator.ZeroShotClassificationOutput;
import ai.djl.modality.nlp.translator.ZeroShotClassificationServingTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ZeroShotClassificationTranslatorFactory
implements TranslatorFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Set<Pair<Type, Type>> SUPPORTED_TYPES = new HashSet<Pair<Type, Type>>();

    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) throws TranslateException {
        Path modelPath = model.getModelPath();
        try {
            HuggingFaceTokenizer tokenizer = HuggingFaceTokenizer.builder(arguments).optTokenizerPath(modelPath).optManager(model.getNDManager()).build();
            ZeroShotClassificationTranslator translator = ZeroShotClassificationTranslator.builder(tokenizer, arguments).build();
            if (input == ZeroShotClassificationInput.class && output == ZeroShotClassificationOutput.class) {
                return translator;
            }
            if (input == Input.class && output == Output.class) {
                return new ZeroShotClassificationServingTranslator(translator);
            }
            throw new IllegalArgumentException("Unsupported input/output types.");
        }
        catch (IOException e) {
            throw new TranslateException("Failed to load tokenizer.", e);
        }
    }

    static {
        SUPPORTED_TYPES.add(new Pair<Class<ZeroShotClassificationInput>, Class<ZeroShotClassificationOutput>>(ZeroShotClassificationInput.class, ZeroShotClassificationOutput.class));
        SUPPORTED_TYPES.add(new Pair<Class<Input>, Class<Output>>(Input.class, Output.class));
    }
}

