/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality;

import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.util.Pair;
import ai.djl.util.PairList;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;

public class Input {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> properties = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    protected PairList<String, BytesSupplier> content = new PairList();
    private boolean cancelled;

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getOrDefault(key, defaultValue);
    }

    public PairList<String, BytesSupplier> getContent() {
        return this.content;
    }

    public PairList<String, ByteBuffer> getContentAsBuffers() {
        PairList<String, ByteBuffer> result = new PairList<String, ByteBuffer>(this.content.size());
        for (Pair<String, BytesSupplier> pair : this.content) {
            result.add(pair.getKey(), pair.getValue().toByteBuffer());
        }
        return result;
    }

    public void setContent(PairList<String, BytesSupplier> content) {
        this.content = content;
    }

    public void add(byte[] data) {
        this.add(BytesSupplier.wrap(data));
    }

    public void add(String data) {
        this.add(BytesSupplier.wrap(data.getBytes(StandardCharsets.UTF_8)));
    }

    public void add(BytesSupplier data) {
        this.add(null, data);
    }

    public void add(String key, byte[] data) {
        this.add(key, BytesSupplier.wrap(data));
    }

    public void add(String key, String data) {
        this.add(key, BytesSupplier.wrap(data));
    }

    public void add(String key, BytesSupplier data) {
        this.content.add(key, data);
    }

    public void add(int index, String key, BytesSupplier data) {
        this.content.add(index, key, data);
    }

    public BytesSupplier getData() {
        if (this.content.isEmpty()) {
            return null;
        }
        BytesSupplier data = this.get("data");
        if (data == null) {
            return this.get(0);
        }
        return data;
    }

    public NDList getDataAsNDList(NDManager manager) {
        if (this.content.isEmpty()) {
            return null;
        }
        int index = this.content.indexOf("data");
        if (index < 0) {
            index = 0;
        }
        return this.getAsNDList(manager, index);
    }

    public BytesSupplier get(String key) {
        return this.content.get(key);
    }

    public BytesSupplier get(int index) {
        return this.content.valueAt(index);
    }

    public byte[] getAsBytes(String key) {
        BytesSupplier data = this.content.get(key);
        if (data == null) {
            return null;
        }
        return data.getAsBytes();
    }

    public byte[] getAsBytes(int index) {
        return this.content.valueAt(index).getAsBytes();
    }

    public String getAsString(String key) {
        BytesSupplier data = this.content.get(key);
        if (data == null) {
            return null;
        }
        return data.getAsString();
    }

    public String getAsString(int index) {
        return this.content.valueAt(index).getAsString();
    }

    public NDArray getAsNDArray(NDManager manager, String key) {
        int index = this.content.indexOf(key);
        if (index < 0) {
            return null;
        }
        return this.getAsNDArray(manager, index);
    }

    public NDArray getAsNDArray(NDManager manager, int index) {
        BytesSupplier data = this.content.valueAt(index);
        if (data instanceof NDArray) {
            return (NDArray)data;
        }
        return NDArray.decode(manager, data.getAsBytes());
    }

    public NDList getAsNDList(NDManager manager, String key) {
        int index = this.content.indexOf(key);
        if (index < 0) {
            return null;
        }
        return this.getAsNDList(manager, index);
    }

    public NDList getAsNDList(NDManager manager, int index) {
        BytesSupplier data = this.content.valueAt(index);
        if (data instanceof NDList) {
            return (NDList)data;
        }
        if (data instanceof NDArray) {
            return new NDList((NDArray)data);
        }
        return NDList.decode(manager, data.getAsBytes());
    }

    public byte[] encode() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            DataOutputStream os = new DataOutputStream(baos);
            os.writeLong(1L);
            this.encodeInputBase(os);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    protected void encodeInputBase(DataOutputStream os) throws IOException {
        os.writeInt(this.properties.size());
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            os.writeUTF(entry.getKey());
            os.writeUTF(entry.getValue());
        }
        os.writeInt(this.content.size());
        for (Pair pair : this.content) {
            if (pair.getKey() != null) {
                os.writeBoolean(true);
                os.writeUTF((String)pair.getKey());
            } else {
                os.writeBoolean(false);
            }
            byte[] cVal = ((BytesSupplier)pair.getValue()).getAsBytes();
            os.writeInt(cVal.length);
            os.write(cVal);
        }
    }

    public static Input decode(InputStream is) throws IOException {
        try (DataInputStream dis = new DataInputStream(is);){
            if (1L != dis.readLong()) {
                throw new IllegalArgumentException("Invalid Input version");
            }
            Input input = new Input();
            Input.decodeInputBase(dis, input);
            Input input2 = input;
            return input2;
        }
    }

    protected static void decodeInputBase(DataInputStream dis, Input input) throws IOException {
        int numProperties = dis.readInt();
        for (int i = 0; i < numProperties; ++i) {
            String key = dis.readUTF();
            String val2 = dis.readUTF();
            input.addProperty(key, val2);
        }
        int numContent = dis.readInt();
        for (int i = 0; i < numContent; ++i) {
            int newRead;
            boolean hasKey = dis.readBoolean();
            String key = null;
            if (hasKey) {
                key = dis.readUTF();
            }
            int contentLength = dis.readInt();
            byte[] contents = new byte[contentLength];
            for (int contentRead = 0; contentRead < contentLength; contentRead += newRead) {
                newRead = dis.read(contents, contentRead, contentLength);
                if (newRead >= 0) continue;
                throw new IOException("Failed to read Input or Output content");
            }
            input.add(key, contents);
        }
    }

    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input input = (Input)o;
        return this.properties.equals(input.properties) && this.getContentAsBuffers().equals(input.getContentAsBuffers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("Input:\n");
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            sb.append("Property ").append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        for (Pair pair : this.content) {
            sb.append("Content ").append((String)pair.getKey()).append(": ").append(((BytesSupplier)pair.getValue()).toString()).append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }
}

