/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.output;

import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.Point;
import ai.djl.util.JsonSerializable;
import ai.djl.util.JsonUtils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public class Rectangle
implements BoundingBox,
JsonSerializable {
    private static final long serialVersionUID = 1L;
    private List<Point> corners;
    private double width;
    private double height;

    public Rectangle(double x, double y, double width, double height) {
        this(new Point(x, y), width, height);
    }

    public Rectangle(Point point, double width, double height) {
        this.width = width;
        this.height = height;
        this.corners = new ArrayList<Point>(4);
        this.corners.add(point);
        this.corners.add(new Point(point.getX() + width, point.getY()));
        this.corners.add(new Point(point.getX() + width, point.getY() + height));
        this.corners.add(new Point(point.getX(), point.getY() + height));
    }

    @Override
    public Rectangle getBounds() {
        return this;
    }

    @Override
    public Iterable<Point> getPath() {
        return this.corners;
    }

    @Override
    public Point getPoint() {
        return this.corners.get(0);
    }

    @Override
    public double getIoU(BoundingBox box) {
        Rectangle rect = box.getBounds();
        double s1 = (this.width + 1.0) * (this.height + 1.0);
        double s2 = (rect.getWidth() + 1.0) * (rect.getHeight() + 1.0);
        double sumArea = s1 + s2;
        double left = Math.max(this.getX(), rect.getX());
        double top = Math.max(this.getY(), rect.getY());
        double right = Math.min(this.getX() + this.getWidth(), rect.getX() + rect.getWidth());
        double bottom = Math.min(this.getY() + this.getHeight(), rect.getY() + rect.getHeight());
        if (left > right || top > bottom) {
            return 0.0;
        }
        double intersect = (right - left + 1.0) * (bottom - top + 1.0);
        return intersect / (sumArea - intersect);
    }

    public double getX() {
        return this.getPoint().getX();
    }

    public double getY() {
        return this.getPoint().getY();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double[] getCoordinates() {
        Point upLeft = this.corners.get(0);
        Point bottomRight = this.corners.get(2);
        return new double[]{upLeft.getX(), upLeft.getY(), bottomRight.getX(), bottomRight.getY()};
    }

    @Override
    public JsonObject serialize() {
        JsonObject ret = new JsonObject();
        ret.add("rect", JsonUtils.GSON.toJsonTree(this.getCoordinates()));
        return ret;
    }

    public String toString() {
        return this.toJson();
    }

    public static List<Integer> nms(List<Rectangle> boxes, List<Double> scores, float nmsThreshold) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        PriorityQueue<Integer> pq = new PriorityQueue<Integer>(50, (lhs, rhs) -> Double.compare((Double)scores.get((int)rhs), (Double)scores.get((int)lhs)));
        for (int i = 0; i < boxes.size(); ++i) {
            pq.add(i);
        }
        while (!pq.isEmpty()) {
            int[] detections = pq.stream().mapToInt(Integer::intValue).toArray();
            ret.add(detections[0]);
            Rectangle box = boxes.get(detections[0]);
            pq.clear();
            for (int i = 1; i < detections.length; ++i) {
                int detection = detections[i];
                Rectangle location = boxes.get(detection);
                if (!(box.boxIou(location) < (double)nmsThreshold)) continue;
                pq.add(detection);
            }
        }
        return ret;
    }

    private double boxIou(Rectangle other) {
        double intersection = this.intersection(other);
        double union = this.getWidth() * this.getHeight() + other.getWidth() * other.getHeight() - intersection;
        return intersection / union;
    }

    private double intersection(Rectangle b) {
        double w = this.overlap((this.getX() * 2.0 + this.getWidth()) / 2.0, this.getWidth(), (b.getX() * 2.0 + b.getWidth()) / 2.0, b.getWidth());
        double h2 = this.overlap((this.getY() * 2.0 + this.getHeight()) / 2.0, this.getHeight(), (b.getY() * 2.0 + b.getHeight()) / 2.0, b.getHeight());
        if (w < 0.0 || h2 < 0.0) {
            return 0.0;
        }
        return w * h2;
    }

    private double overlap(double x1, double w1, double x2, double w2) {
        double l1 = x1 - w1 / 2.0;
        double l2 = x2 - w2 / 2.0;
        double left = Math.max(l1, l2);
        double r1 = x1 + w1 / 2.0;
        double r2 = x2 + w2 / 2.0;
        double right = Math.min(r1, r2);
        return right - left;
    }
}

