/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.transform;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.Transform;

public class Pad
implements Transform {
    private double value;

    public Pad(double value) {
        this.value = value;
    }

    @Override
    public NDArray transform(NDArray array) {
        int h2;
        Shape shape = array.getShape();
        int w = (int)shape.get(1);
        if (w == (h2 = (int)shape.get(0))) {
            return array;
        }
        int max = Math.max(w, h2);
        int padW = max - w;
        int padH = max - h2;
        Shape padding = new Shape(0L, 0L, 0L, padW, 0L, padH);
        array = array.pad(padding, this.value);
        return array;
    }
}

