/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.transform;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.Transform;

public class ResizeShort
implements Transform {
    private int shortEdge;
    private int longEdge;
    private Image.Interpolation interpolation;

    public ResizeShort(int shortEdge) {
        this(shortEdge, -1, Image.Interpolation.BILINEAR);
    }

    public ResizeShort(int shortEdge, int longEdge, Image.Interpolation interpolation) {
        this.shortEdge = shortEdge;
        this.longEdge = longEdge;
        this.interpolation = interpolation;
    }

    @Override
    public NDArray transform(NDArray array) {
        int rescaledHeight;
        int rescaledWidth;
        int newLong;
        int newShort;
        Shape shape = array.getShape();
        int width = (int)shape.get(1);
        int height = (int)shape.get(0);
        int min2 = Math.min(width, height);
        int max = Math.max(width, height);
        if (this.shortEdge < 0) {
            newShort = min2 * this.longEdge / max;
            newLong = this.longEdge;
        } else {
            newShort = this.shortEdge;
            newLong = max * this.shortEdge / min2;
            if (this.longEdge > 0 && newLong > this.longEdge) {
                newShort = min2 * this.longEdge / max;
                newLong = this.longEdge;
            }
        }
        if (width > height) {
            rescaledWidth = newLong;
            rescaledHeight = newShort;
        } else {
            rescaledWidth = newShort;
            rescaledHeight = newLong;
        }
        return NDImageUtils.resize(array, rescaledWidth, rescaledHeight, this.interpolation);
    }
}

