/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.translator.ObjectDetectionTranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.TranslatorContext;
import java.util.ArrayList;
import java.util.Map;

public class SingleShotDetectionTranslator
extends ObjectDetectionTranslator {
    public SingleShotDetectionTranslator(Builder builder) {
        super(builder);
    }

    @Override
    public DetectedObjects processOutput(TranslatorContext ctx, NDList list) {
        float[] classIds = ((NDArray)list.get(0)).toFloatArray();
        float[] probabilities = ((NDArray)list.get(1)).toFloatArray();
        NDArray boundingBoxes = (NDArray)list.get(2);
        ArrayList<String> retNames = new ArrayList<String>();
        ArrayList<Double> retProbs = new ArrayList<Double>();
        ArrayList<BoundingBox> retBB = new ArrayList<BoundingBox>();
        for (int i = 0; i < classIds.length; ++i) {
            int classId = (int)classIds[i];
            double probability = probabilities[i];
            if (classId < 0 || !(probability > (double)this.threshold)) continue;
            if (classId >= this.classes.size()) {
                throw new AssertionError((Object)("Unexpected index: " + classId));
            }
            String className = (String)this.classes.get(classId);
            float[] box = boundingBoxes.get(i).toFloatArray();
            double x = this.width > 0 ? (double)(box[0] / (float)this.width) : (double)box[0];
            double y = this.height > 0 ? (double)(box[1] / (float)this.height) : (double)box[1];
            double w = this.width > 0 ? (double)(box[2] / (float)this.width) - x : (double)box[2] - x;
            double h2 = this.height > 0 ? (double)(box[3] / (float)this.height) - y : (double)box[3] - y;
            Rectangle rect = this.applyRatio ? new Rectangle(x / (double)this.width, y / (double)this.height, w / (double)this.width, h2 / (double)this.height) : new Rectangle(x, y, w, h2);
            retNames.add(className);
            retProbs.add(probability);
            retBB.add(rect);
        }
        return new DetectedObjects(retNames, retProbs, retBB);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Map<String, ?> arguments) {
        Builder builder = new Builder();
        builder.configPreProcess(arguments);
        builder.configPostProcess(arguments);
        return builder;
    }

    public static class Builder
    extends ObjectDetectionTranslator.ObjectDetectionBuilder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        public SingleShotDetectionTranslator build() {
            this.validate();
            return new SingleShotDetectionTranslator(this);
        }
    }
}

