/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.translator;

import ai.djl.modality.Input;
import ai.djl.translate.TranslateException;
import ai.djl.util.JsonUtils;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;

public class ZeroShotClassificationInput {
    private String text;
    @SerializedName(value="candidate_labels")
    private String[] candidates;
    @SerializedName(value="multi_label")
    private boolean multiLabel;
    @SerializedName(value="hypothesis_template")
    private String hypothesisTemplate;

    public ZeroShotClassificationInput(String text, String[] candidates) {
        this(text, candidates, false);
    }

    public ZeroShotClassificationInput(String text, String[] candidates, boolean multiLabel) {
        this(text, candidates, multiLabel, null);
    }

    public ZeroShotClassificationInput(String text, String[] candidates, boolean multiLabel, String hypothesisTemplate) {
        this.text = text;
        this.candidates = candidates;
        this.multiLabel = multiLabel;
        this.hypothesisTemplate = hypothesisTemplate;
    }

    public static ZeroShotClassificationInput parseInput(Input input) throws TranslateException {
        String text = input.getData().getAsString();
        try {
            return JsonUtils.GSON.fromJson(text, ZeroShotClassificationInput.class);
        }
        catch (JsonParseException e) {
            throw new TranslateException("Input is not a valid json.", e);
        }
    }

    public String getText() {
        return this.text;
    }

    public String[] getCandidates() {
        return this.candidates;
    }

    public boolean isMultiLabel() {
        return this.multiLabel;
    }

    public String getHypothesisTemplate() {
        return this.hypothesisTemplate == null ? "This example is {}." : this.hypothesisTemplate;
    }
}

