/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn.norm;

import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.AbstractBlock;
import ai.djl.nn.Parameter;
import ai.djl.training.ParameterStore;
import ai.djl.util.PairList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BatchNorm
extends AbstractBlock {
    private static final byte VERSION = 2;
    private int axis;
    private float epsilon;
    private float momentum;
    private long inChannels;
    private boolean center;
    private boolean scale;
    private Parameter gamma;
    private Parameter beta;
    private Parameter runningMean;
    private Parameter runningVar;

    BatchNorm(BaseBuilder<?> builder) {
        super((byte)2);
        this.axis = builder.axis;
        this.epsilon = builder.epsilon;
        this.momentum = builder.momentum;
        this.center = builder.center;
        this.scale = builder.scale;
        this.gamma = this.addParameter(Parameter.builder().setName("gamma").setType(Parameter.Type.GAMMA).optRequiresGrad(this.scale).build());
        this.beta = this.addParameter(Parameter.builder().setName("beta").setType(Parameter.Type.BETA).optRequiresGrad(this.center).build());
        this.runningMean = this.addParameter(Parameter.builder().setName("runningMean").setType(Parameter.Type.RUNNING_MEAN).optRequiresGrad(false).build());
        this.runningVar = this.addParameter(Parameter.builder().setName("runningVar").setType(Parameter.Type.RUNNING_VAR).optRequiresGrad(false).build());
    }

    @Override
    protected NDList forwardInternal(ParameterStore parameterStore, NDList inputs, boolean training, PairList<String, Object> params) {
        NDArray input = inputs.singletonOrThrow();
        Device device = input.getDevice();
        NDArray gammaArr = parameterStore.getValue(this.gamma, device, training);
        NDArray betaArr = parameterStore.getValue(this.beta, device, training);
        NDArray runningMeanArr = parameterStore.getValue(this.runningMean, device, training);
        NDArray runningVarArr = parameterStore.getValue(this.runningVar, device, training);
        return BatchNorm.batchNorm(input, runningMeanArr, runningVarArr, gammaArr, betaArr, this.axis, this.momentum, this.epsilon, training);
    }

    @Override
    public Shape[] getOutputShapes(Shape[] inputShapes) {
        return new Shape[]{inputShapes[0]};
    }

    @Override
    protected void beforeInitialize(Shape ... inputShapes) {
        super.beforeInitialize(inputShapes);
        this.inChannels = inputShapes[0].size(this.axis);
    }

    @Override
    public void prepare(Shape[] inputShapes) {
        this.gamma.setShape(new Shape(this.inChannels));
        this.beta.setShape(new Shape(this.inChannels));
        this.runningMean.setShape(new Shape(this.inChannels));
        this.runningVar.setShape(new Shape(this.inChannels));
    }

    @Override
    protected void saveMetadata(DataOutputStream os) throws IOException {
        this.saveInputShapes(os);
        os.writeLong(this.inChannels);
    }

    @Override
    public void loadMetadata(byte loadVersion, DataInputStream is) throws IOException, MalformedModelException {
        if (loadVersion == 2) {
            this.readInputShapes(is);
        } else if (loadVersion != 1) {
            throw new MalformedModelException("Unsupported encoding version: " + loadVersion);
        }
        this.inChannels = is.readLong();
    }

    public static NDList batchNorm(NDArray input, NDArray runningMean, NDArray runningVar) {
        NDArrayEx ex = input.getNDArrayInternal();
        return ex.batchNorm(input, runningMean, runningVar, null, null, 1, 0.9f, 1.0E-5f, true);
    }

    public static NDList batchNorm(NDArray input, NDArray runningMean, NDArray runningVar, NDArray gamma, NDArray beta) {
        NDArrayEx ex = input.getNDArrayInternal();
        return ex.batchNorm(input, runningMean, runningVar, gamma, beta, 1, 0.9f, 1.0E-5f, true);
    }

    public static NDList batchNorm(NDArray input, NDArray runningMean, NDArray runningVar, NDArray gamma, NDArray beta, int axis) {
        NDArrayEx ex = input.getNDArrayInternal();
        return ex.batchNorm(input, runningMean, runningVar, gamma, beta, axis, 0.9f, 1.0E-5f, true);
    }

    public static NDList batchNorm(NDArray input, NDArray runningMean, NDArray runningVar, NDArray gamma, NDArray beta, int axis, float momentum, float eps, boolean training) {
        NDArrayEx ex = input.getNDArrayInternal();
        return ex.batchNorm(input, runningMean, runningVar, gamma, beta, axis, momentum, eps, training);
    }

    public static BaseBuilder<?> builder() {
        return new Builder();
    }

    public static abstract class BaseBuilder<T extends BaseBuilder<T>> {
        protected int axis = 1;
        protected float epsilon = 1.0E-5f;
        protected float momentum = 0.9f;
        protected boolean center = true;
        protected boolean scale = true;

        protected BaseBuilder() {
        }

        public T optAxis(int axis) {
            this.axis = axis;
            return this.self();
        }

        public T optCenter(boolean val2) {
            this.center = val2;
            return this.self();
        }

        public T optScale(boolean val2) {
            this.scale = val2;
            return this.self();
        }

        public T optEpsilon(float val2) {
            this.epsilon = val2;
            return this.self();
        }

        public T optMomentum(float val2) {
            this.momentum = val2;
            return this.self();
        }

        public abstract BatchNorm build();

        public abstract T self();
    }

    public static class Builder
    extends BaseBuilder<Builder> {
        Builder() {
        }

        @Override
        public BatchNorm build() {
            return new BatchNorm(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

