/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.FilenameUtils;
import ai.djl.repository.JarRepository;
import ai.djl.repository.LocalRepository;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.repository.RemoteRepository;
import ai.djl.repository.Repository;
import ai.djl.repository.RepositoryFactory;
import ai.djl.repository.SimpleRepository;
import ai.djl.repository.SimpleUrlRepository;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.JsonUtils;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryFactoryImpl
implements RepositoryFactory {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryFactoryImpl.class);
    private static final RepositoryFactory FACTORY = new RepositoryFactoryImpl();
    private static final Map<String, RepositoryFactory> REGISTRY = RepositoryFactoryImpl.init();
    private static final Pattern PATTERN = Pattern.compile("(.+)/([\\d.]+)(/(.*))?");

    RepositoryFactoryImpl() {
    }

    static RepositoryFactory getFactory() {
        return FACTORY;
    }

    @Override
    public Repository newInstance(String name, URI uri) {
        RepositoryFactory factory;
        String scheme = uri.getScheme();
        if (scheme == null) {
            scheme = "file";
        }
        if ((factory = REGISTRY.get(scheme)) != null) {
            return factory.newInstance(name, uri);
        }
        try {
            uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + uri, e);
        }
        if ("tfhub.dev".equals(uri.getHost().toLowerCase(Locale.ROOT))) {
            String path = uri.getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            path = "/tfhub-modules" + path + ".tar.gz";
            try {
                uri = new URI("https", null, "storage.googleapis.com", -1, path, null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Failed to append query string: " + uri, e);
            }
            String[] tokens = path.split("/");
            String modelName = tokens[tokens.length - 2];
            return new SimpleUrlRepository(name, uri, modelName);
        }
        Path path = Paths.get(RepositoryFactoryImpl.parseFilePath(uri), new String[0]);
        String fileName = path.toFile().getName();
        if (FilenameUtils.isArchiveFile(fileName)) {
            fileName = FilenameUtils.getNamePart(fileName);
            return new SimpleUrlRepository(name, uri, fileName);
        }
        return new RemoteRepository(name, uri);
    }

    @Override
    public Set<String> getSupportedScheme() {
        return REGISTRY.keySet();
    }

    static void registerRepositoryFactory(RepositoryFactory factory) {
        for (String scheme : factory.getSupportedScheme()) {
            REGISTRY.put(scheme, factory);
        }
    }

    private static Map<String, RepositoryFactory> init() {
        ConcurrentHashMap<String, RepositoryFactory> registry = new ConcurrentHashMap<String, RepositoryFactory>();
        registry.put("file", new LocalRepositoryFactory());
        registry.put("jar", new JarRepositoryFactory());
        registry.put("djl", new DjlRepositoryFactory());
        ServiceLoader<RepositoryFactory> factories = ServiceLoader.load(RepositoryFactory.class);
        for (RepositoryFactory factory : factories) {
            for (String scheme : factory.getSupportedScheme()) {
                registry.put(scheme, factory);
            }
        }
        return registry;
    }

    static String parseFilePath(URI uri) {
        String uriPath = uri.getPath();
        if (uriPath == null) {
            uriPath = uri.getSchemeSpecificPart();
        }
        if (uriPath.startsWith("file:")) {
            uriPath = uriPath.substring(5);
        }
        if (uriPath.startsWith("/") && System.getProperty("os.name").startsWith("Win")) {
            uriPath = uriPath.substring(1);
        }
        return uriPath;
    }

    private static final class LocalRepositoryFactory
    implements RepositoryFactory {
        private LocalRepositoryFactory() {
        }

        @Override
        public Repository newInstance(String name, URI uri) {
            Path path = Paths.get(RepositoryFactoryImpl.parseFilePath(uri), new String[0]);
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                try {
                    if (Files.walk(path, new FileVisitOption[0]).anyMatch(f -> this.isLocalRepository(path, (Path)f))) {
                        logger.debug("Found local repository: {}", (Object)path);
                        return new LocalRepository(name, path.toUri(), path);
                    }
                }
                catch (IOException e) {
                    logger.warn("Failed locate metadata.json file, defaulting to simple", e);
                }
            }
            return new SimpleRepository(name, uri, path);
        }

        private boolean isLocalRepository(Path root, Path file) {
            boolean bl;
            block10: {
                if (!Files.isRegularFile(file, new LinkOption[0]) || root.equals(file.getParent())) {
                    return false;
                }
                if (!"metadata.json".equals(file.toFile().getName())) {
                    return false;
                }
                BufferedReader reader = Files.newBufferedReader(file);
                try {
                    Metadata metadata = JsonUtils.GSON.fromJson((Reader)reader, Metadata.class);
                    boolean bl2 = bl = metadata.getMetadataVersion() != null && metadata.getArtifacts() != null;
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonParseException | IOException e) {
                        logger.warn("Invalid metadata.json file", e);
                        return false;
                    }
                }
                ((Reader)reader).close();
            }
            return bl;
        }

        @Override
        public Set<String> getSupportedScheme() {
            return Collections.singleton("file");
        }
    }

    private static final class JarRepositoryFactory
    implements RepositoryFactory {
        private JarRepositoryFactory() {
        }

        @Override
        public Repository newInstance(String name, URI uri) {
            URI realUri;
            URL u;
            String p = uri.getPath();
            if (p.startsWith("/")) {
                p = p.substring(1);
            }
            if ((u = ClassLoaderUtils.getContextClassLoader().getResource(p)) == null) {
                throw new IllegalArgumentException("Resource not found: " + uri);
            }
            try {
                realUri = u.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Resource not found: " + uri, e);
            }
            Path path = Paths.get(RepositoryFactoryImpl.parseFilePath(realUri), new String[0]);
            String fileName = path.toFile().getName();
            if (FilenameUtils.isArchiveFile(fileName)) {
                fileName = FilenameUtils.getNamePart(fileName);
            }
            return new JarRepository(name, uri, fileName, realUri);
        }

        @Override
        public Set<String> getSupportedScheme() {
            return Collections.singleton("jar");
        }
    }

    private static final class DjlRepositoryFactory
    implements RepositoryFactory {
        private DjlRepositoryFactory() {
        }

        @Override
        public Repository newInstance(String name, URI uri) {
            ModelZoo zoo;
            String queryString = uri.getQuery();
            URI djlUri = queryString != null ? URI.create("https://mlrepo.djl.ai/?" + queryString) : URI.create("https://mlrepo.djl.ai/");
            RemoteRepository repo = new RemoteRepository(name, djlUri);
            String groupId = uri.getHost();
            if (groupId == null) {
                throw new IllegalArgumentException("Invalid djl URL: " + uri);
            }
            String artifactId = RepositoryFactoryImpl.parseFilePath(uri);
            if (artifactId.startsWith("/")) {
                artifactId = artifactId.substring(1);
            }
            if (artifactId.isEmpty()) {
                throw new IllegalArgumentException("Invalid djl URL: " + uri);
            }
            String version = null;
            String artifactName = null;
            Matcher m4 = PATTERN.matcher(artifactId);
            if (m4.matches()) {
                artifactId = m4.group(1);
                version = m4.group(2);
                artifactName = m4.group(4);
            }
            if ((zoo = ModelZoo.getModelZoo(groupId)) == null) {
                throw new IllegalArgumentException("ModelZoo not found in classpath: " + groupId);
            }
            ModelLoader loader = zoo.getModelLoader(artifactId);
            if (loader == null) {
                throw new IllegalArgumentException("Invalid djl URL: " + uri);
            }
            MRL mrl = repo.model(loader.getApplication(), groupId, artifactId, version, artifactName);
            repo.addResource(mrl);
            return repo;
        }

        @Override
        public Set<String> getSupportedScheme() {
            return Collections.singleton("djl");
        }
    }
}

