/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import ai.djl.util.JsonSerializable;
import ai.djl.util.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;

public interface JsonUtils {
    public static final boolean PRETTY_PRINT = Boolean.parseBoolean(Utils.getEnvOrSystemProperty("DJL_PRETTY_PRINT"));
    public static final Gson GSON = JsonUtils.builder().create();
    public static final Gson GSON_COMPACT = JsonUtils.builder(false).create();
    public static final Gson GSON_PRETTY = JsonUtils.builder(true).create();
    public static final Type LIST_TYPE = new TypeToken<List<String>>(){}.getType();

    public static GsonBuilder builder() {
        return JsonUtils.builder(PRETTY_PRINT);
    }

    public static GsonBuilder builder(boolean prettyPrint) {
        GsonBuilder builder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").serializeSpecialFloatingPointValues().registerTypeHierarchyAdapter(JsonSerializable.class, new JsonSerializable.Serializer()).registerTypeAdapter((Type)((Object)Double.class), (src, t2, ctx) -> {
            long v = src.longValue();
            if (src.equals(Double.valueOf(String.valueOf(v)))) {
                return new JsonPrimitive(v);
            }
            return new JsonPrimitive((Number)src);
        });
        if (prettyPrint) {
            builder.setPrettyPrinting();
        }
        return builder;
    }

    public static String toJson(Object src) {
        return GSON.toJson(src);
    }
}

