/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.JettyModernServerAdapter;
import ch.qos.logback.access.jetty.JettyServerAdapter;
import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.util.FileUtil;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.LifeCycle;

public class RequestLogImpl
extends ContextBase
implements LifeCycle,
RequestLog,
AppenderAttachable<IAccessEvent>,
FilterAttachable<IAccessEvent> {
    public static final String DEFAULT_CONFIG_FILE = "etc" + File.separatorChar + "logback-access.xml";
    State state = State.STOPPED;
    AppenderAttachableImpl<IAccessEvent> aai = new AppenderAttachableImpl();
    FilterAttachableImpl<IAccessEvent> fai = new FilterAttachableImpl();
    String fileName;
    String resource;
    boolean quiet = false;

    public RequestLogImpl() {
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    @Override
    public void log(Request jettyRequest, Response jettyResponse) {
        JettyServerAdapter adapter = this.makeJettyServerAdapter(jettyRequest, jettyResponse);
        AccessEvent accessEvent = new AccessEvent(this, jettyRequest, jettyResponse, adapter);
        if (this.getFilterChainDecision(accessEvent) == FilterReply.DENY) {
            return;
        }
        this.aai.appendLoopOnAppenders(accessEvent);
    }

    private JettyServerAdapter makeJettyServerAdapter(Request jettyRequest, Response jettyResponse) {
        return new JettyModernServerAdapter(jettyRequest, jettyResponse);
    }

    protected void addInfo(String msg) {
        this.getStatusManager().add(new InfoStatus(msg, this));
    }

    private void addError(String msg) {
        this.getStatusManager().add(new ErrorStatus(msg, this));
    }

    @Override
    public void start() {
        this.state = State.STARTING;
        try {
            this.configure();
            if (!this.isQuiet()) {
                StatusPrinter.print(this.getStatusManager());
            }
            this.state = State.STARTED;
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            this.state = State.FAILED;
        }
    }

    protected void configure() {
        URL configURL = this.getConfigurationFileURL();
        if (configURL != null) {
            this.runJoranOnFile(configURL);
        } else {
            this.addError("Could not find configuration file for logback-access");
        }
    }

    protected URL getConfigurationFileURL() {
        File file;
        if (this.fileName != null) {
            this.addInfo("Will use configuration file [" + this.fileName + "]");
            File file2 = new File(this.fileName);
            if (!file2.exists()) {
                return null;
            }
            return FileUtil.fileToURL(file2);
        }
        if (this.resource != null) {
            this.addInfo("Will use configuration resource [" + this.resource + "]");
            return this.getClass().getResource(this.resource);
        }
        Object defaultConfigFile = DEFAULT_CONFIG_FILE;
        String jettyBaseProperty = OptionHelper.getSystemProperty("jetty.base");
        if (!OptionHelper.isNullOrEmpty(jettyBaseProperty)) {
            defaultConfigFile = jettyBaseProperty + File.separatorChar + DEFAULT_CONFIG_FILE;
        }
        if (!(file = new File((String)defaultConfigFile)).exists()) {
            String jettyHomeProperty = OptionHelper.getSystemProperty("jetty.home");
            if (!OptionHelper.isEmpty(jettyHomeProperty)) {
                defaultConfigFile = jettyHomeProperty + File.separatorChar + DEFAULT_CONFIG_FILE;
            } else {
                this.addInfo("Neither [jetty.base] nor [jetty.home] system properties are set.");
            }
        }
        file = new File((String)defaultConfigFile);
        this.addInfo("Assuming default configuration file [" + (String)defaultConfigFile + "]");
        if (!file.exists()) {
            return null;
        }
        return FileUtil.fileToURL(file);
    }

    private void runJoranOnFile(URL configURL) {
        try {
            JoranConfigurator jc = new JoranConfigurator();
            jc.setContext(this);
            jc.doConfigure(configURL);
            if (this.getName() == null) {
                this.setName("LogbackRequestLog");
            }
        }
        catch (JoranException joranException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        this.state = State.STOPPING;
        this.aai.detachAndStopAllAppenders();
        this.state = State.STOPPED;
    }

    @Override
    public boolean isRunning() {
        return this.state == State.STARTED;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    @Override
    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    @Override
    public boolean isStarting() {
        return this.state == State.STARTING;
    }

    @Override
    public boolean isStopping() {
        return this.state == State.STOPPING;
    }

    @Override
    public boolean isStopped() {
        return this.state == State.STOPPED;
    }

    @Override
    public boolean isFailed() {
        return this.state == State.FAILED;
    }

    @Override
    public boolean addEventListener(EventListener listener) {
        return false;
    }

    @Override
    public boolean removeEventListener(EventListener listener) {
        return false;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void addAppender(Appender<IAccessEvent> newAppender) {
        this.aai.addAppender(newAppender);
    }

    @Override
    public Iterator<Appender<IAccessEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    @Override
    public Appender<IAccessEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    @Override
    public boolean isAttached(Appender<IAccessEvent> appender) {
        return this.aai.isAttached(appender);
    }

    @Override
    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    @Override
    public boolean detachAppender(Appender<IAccessEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    @Override
    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    @Override
    public void addFilter(Filter<IAccessEvent> newFilter) {
        this.fai.addFilter(newFilter);
    }

    @Override
    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    @Override
    public List<Filter<IAccessEvent>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    @Override
    public FilterReply getFilterChainDecision(IAccessEvent event) {
        return this.fai.getFilterChainDecision(event);
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
    }

    static enum State {
        FAILED,
        STOPPED,
        STARTING,
        STARTED,
        STOPPING;

    }
}

