/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.tomcat;

import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.tomcat.TomcatServerAdapter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.LifeCycleManager;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.ConfigurationEventListener;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.LogbackLock;
import ch.qos.logback.core.spi.SequenceNumberGenerator;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.ExecutorServiceUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class LogbackValve
extends ValveBase
implements Lifecycle,
ch.qos.logback.core.Context,
AppenderAttachable<IAccessEvent>,
FilterAttachable<IAccessEvent> {
    public static final String DEFAULT_FILENAME = "logback-access.xml";
    public static final String DEFAULT_CONFIG_FILE = "conf" + File.separatorChar + "logback-access.xml";
    static final String CATALINA_BASE_KEY = "catalina.base";
    static final String CATALINA_HOME_KEY = "catalina.home";
    private final LifeCycleManager lifeCycleManager = new LifeCycleManager();
    private long birthTime = System.currentTimeMillis();
    LogbackLock configurationLock = new LogbackLock();
    private final List<ConfigurationEventListener> configurationEventListenerList = new ArrayList<ConfigurationEventListener>();
    private String name;
    StatusManager sm = new BasicStatusManager();
    Map<String, String> propertyMap = new HashMap<String, String>();
    Map<String, Object> objectMap = new HashMap<String, Object>();
    private FilterAttachableImpl<IAccessEvent> fai = new FilterAttachableImpl();
    AppenderAttachableImpl<IAccessEvent> aai = new AppenderAttachableImpl();
    String filenameOption;
    boolean quiet;
    boolean started;
    boolean alreadySetLogbackStatusManager = false;
    private SequenceNumberGenerator sequenceNumberGenerator;
    private ScheduledExecutorService scheduledExecutorService;

    public LogbackValve() {
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    public boolean isStarted() {
        return this.started;
    }

    public void startInternal() throws LifecycleException {
        URL resourceURL;
        String filename;
        this.scheduledExecutorService = ExecutorServiceUtil.newScheduledExecutorService();
        if (this.filenameOption != null) {
            filename = this.filenameOption;
        } else {
            this.addInfo("filename property not set. Assuming [" + DEFAULT_CONFIG_FILE + "]");
            filename = DEFAULT_CONFIG_FILE;
        }
        File configFile = this.searchForConfigFileTomcatProperty(filename, CATALINA_BASE_KEY);
        if (configFile == null) {
            configFile = this.searchForConfigFileTomcatProperty(filename, CATALINA_HOME_KEY);
        }
        if ((resourceURL = configFile != null ? this.fileToUrl(configFile) : this.searchAsResource(filename)) != null) {
            this.configureAsResource(resourceURL);
        } else {
            this.addWarn("Failed to find valid logback-access configuration file.");
        }
        if (!this.quiet) {
            StatusListenerConfigHelper.addOnConsoleListenerInstance(this, new OnConsoleStatusListener());
        }
        this.started = true;
        this.setState(LifecycleState.STARTING);
    }

    private URL fileToUrl(File configFile) {
        try {
            return configFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("File to URL conversion failed", e);
        }
    }

    private URL searchAsResource(String filename) {
        URL result = Loader.getResource(filename, this.getClass().getClassLoader());
        if (result != null) {
            this.addInfo("Found [" + filename + "] as a resource.");
        } else {
            this.addInfo("Could NOT find [" + filename + "] as a resource.");
        }
        return result;
    }

    private File searchForConfigFileTomcatProperty(String filename, String propertyKey) {
        String propertyValue = OptionHelper.getSystemProperty(propertyKey);
        String candidatePath = propertyValue + File.separatorChar + filename;
        if (propertyValue == null) {
            this.addInfo("System property \"" + propertyKey + "\" is not set. Skipping configuration file search with ${" + propertyKey + "} path prefix.");
            return null;
        }
        File candidateFile = new File(candidatePath);
        if (candidateFile.exists()) {
            this.addInfo("Found configuration file [" + candidatePath + "] using property \"" + propertyKey + "\"");
            return candidateFile;
        }
        this.addInfo("Could NOT find configuration file [" + candidatePath + "] using property \"" + propertyKey + "\"");
        return null;
    }

    public void addStatus(Status status) {
        StatusManager sm = this.getStatusManager();
        if (sm != null) {
            sm.add(status);
        }
    }

    public void addInfo(String msg) {
        this.addStatus(new InfoStatus(msg, this));
    }

    public void addWarn(String msg) {
        this.addStatus(new WarnStatus(msg, this));
    }

    public void addError(String msg, Throwable t2) {
        this.addStatus(new ErrorStatus(msg, this, t2));
    }

    private void configureAsResource(URL resourceURL) {
        try {
            JoranConfigurator jc = new JoranConfigurator();
            jc.setContext(this);
            jc.doConfigure(resourceURL);
            this.addInfo("Done configuring");
        }
        catch (JoranException e) {
            this.addError("Failed to configure LogbackValve", e);
        }
    }

    public String getFilename() {
        return this.filenameOption;
    }

    public void setFilename(String filename) {
        this.filenameOption = filename;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            if (!this.alreadySetLogbackStatusManager) {
                ServletContext sc;
                this.alreadySetLogbackStatusManager = true;
                Context tomcatContext = request.getContext();
                if (tomcatContext != null && (sc = tomcatContext.getServletContext()) != null) {
                    sc.setAttribute("LOGBACK_STATUS_MANAGER", this.getStatusManager());
                }
            }
            this.getNext().invoke(request, response);
            TomcatServerAdapter adapter = new TomcatServerAdapter(request, response);
            AccessEvent accessEvent = new AccessEvent(this, (HttpServletRequest)request, (HttpServletResponse)response, adapter);
            this.addThreadName(accessEvent);
            if (this.getFilterChainDecision(accessEvent) == FilterReply.DENY) {
                return;
            }
            this.aai.appendLoopOnAppenders(accessEvent);
        }
        finally {
            request.removeAttribute("LOGBACK_STATUS_MANAGER");
        }
    }

    private void addThreadName(IAccessEvent accessEvent) {
        try {
            String threadName = Thread.currentThread().getName();
            if (threadName != null) {
                accessEvent.setThreadName(threadName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void stopInternal() throws LifecycleException {
        this.started = false;
        this.setState(LifecycleState.STOPPING);
        this.lifeCycleManager.reset();
        if (this.scheduledExecutorService != null) {
            ExecutorServiceUtil.shutdown(this.scheduledExecutorService);
            this.scheduledExecutorService = null;
        }
    }

    @Override
    public void addAppender(Appender<IAccessEvent> newAppender) {
        this.aai.addAppender(newAppender);
    }

    @Override
    public Iterator<Appender<IAccessEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    @Override
    public Appender<IAccessEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    @Override
    public boolean isAttached(Appender<IAccessEvent> appender) {
        return this.aai.isAttached(appender);
    }

    @Override
    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    @Override
    public boolean detachAppender(Appender<IAccessEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    @Override
    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    public String getInfo() {
        return "Logback's implementation of ValveBase";
    }

    @Override
    public StatusManager getStatusManager() {
        return this.sm;
    }

    public Map<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    @Override
    public void putProperty(String key, String val2) {
        this.propertyMap.put(key, val2);
    }

    @Override
    public String getProperty(String key) {
        return this.propertyMap.get(key);
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertyMap);
    }

    @Override
    public Object getObject(String key) {
        return this.objectMap.get(key);
    }

    @Override
    public void putObject(String key, Object value) {
        this.objectMap.put(key, value);
    }

    @Override
    public void addFilter(Filter<IAccessEvent> newFilter) {
        this.fai.addFilter(newFilter);
    }

    @Override
    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    @Override
    public List<Filter<IAccessEvent>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    @Override
    public FilterReply getFilterChainDecision(IAccessEvent event) {
        return this.fai.getFilterChainDecision(event);
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.getScheduledExecutorService();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("LogbackValve has been already given a name");
        }
        this.name = name;
    }

    @Override
    public long getBirthTime() {
        return this.birthTime;
    }

    @Override
    public Object getConfigurationLock() {
        return this.configurationLock;
    }

    @Override
    public void register(LifeCycle component) {
        this.lifeCycleManager.register(component);
    }

    public void addLifecycleListener(LifecycleListener arg0) {
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    public void removeLifecycleListener(LifecycleListener arg0) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('[');
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Override
    public void addScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SequenceNumberGenerator getSequenceNumberGenerator() {
        return this.sequenceNumberGenerator;
    }

    @Override
    public void setSequenceNumberGenerator(SequenceNumberGenerator sequenceNumberGenerator) {
        this.sequenceNumberGenerator = sequenceNumberGenerator;
    }

    @Override
    public void addConfigurationEventListener(ConfigurationEventListener listener) {
        this.configurationEventListenerList.add(listener);
    }

    @Override
    public void fireConfigurationEvent(ConfigurationEvent configurationEvent) {
        this.configurationEventListenerList.forEach(l -> l.listen(configurationEvent));
    }
}

