/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.core.util.Base64Util;
import com.azure.core.util.BinaryData;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public final class EmbeddingsUtils {
    public static BinaryData addEncodingFormat(BinaryData inputJson) {
        Map mapJson = inputJson.toObject(Map.class);
        if (mapJson.containsKey("encoding_format")) {
            return inputJson;
        }
        mapJson.put("encoding_format", "base64");
        return BinaryData.fromObject(mapJson);
    }

    public static List<Float> convertBase64ToFloatList(String embedding) {
        byte[] bytes = Base64Util.decodeString(embedding);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        ArrayList<Float> floatList = new ArrayList<Float>(floatBuffer.remaining());
        while (floatBuffer.hasRemaining()) {
            floatList.add(Float.valueOf(floatBuffer.get()));
        }
        return floatList;
    }

    public static String convertFloatListToBase64(List<Float> floatList) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(floatList.size() * 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (Float f : floatList) {
            byteBuffer.putFloat(f.floatValue());
        }
        byte[] byteArray = byteBuffer.array();
        return Base64.getEncoder().withoutPadding().encodeToString(byteArray);
    }
}

