/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;

public final class MultipartFormDataHelper {
    private static final String CRLF = "\r\n";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private final String boundary;
    private final String partSeparator;
    private final String endMarker;
    private final Charset encoderCharset = StandardCharsets.UTF_8;
    private InputStream requestDataStream = new ByteArrayInputStream(new byte[0]);
    private long requestLength = 0L;
    private RequestOptions requestOptions;
    private BinaryData requestBody;

    public MultipartFormDataHelper(RequestOptions requestOptions) {
        this(requestOptions, UUID.randomUUID().toString().substring(0, 16));
    }

    private MultipartFormDataHelper(RequestOptions requestOptions, String boundary) {
        this.requestOptions = requestOptions;
        this.boundary = boundary;
        this.partSeparator = "--" + boundary;
        this.endMarker = this.partSeparator + "--";
    }

    public BinaryData getRequestBody() {
        return this.requestBody;
    }

    public MultipartFormDataHelper serializeTextField(String fieldName, String value) {
        if (value != null) {
            String serialized = this.partSeparator + CRLF + "Content-Disposition: form-data; name=\"" + MultipartFormDataHelper.escapeName(fieldName) + "\"" + CRLF + CRLF + value + CRLF;
            byte[] data = serialized.getBytes(this.encoderCharset);
            this.appendBytes(data);
        }
        return this;
    }

    public MultipartFormDataHelper serializeJsonField(String fieldName, Object jsonObject) {
        if (jsonObject != null) {
            String serialized = this.partSeparator + CRLF + "Content-Disposition: form-data; name=\"" + MultipartFormDataHelper.escapeName(fieldName) + "\"" + CRLF + "Content-Type: application/json" + CRLF + CRLF + BinaryData.fromObject(jsonObject) + CRLF;
            byte[] data = serialized.getBytes(this.encoderCharset);
            this.appendBytes(data);
        }
        return this;
    }

    public MultipartFormDataHelper serializeFileField(String fieldName, BinaryData file, String contentType, String filename) {
        if (file != null) {
            if (CoreUtils.isNullOrEmpty(contentType)) {
                contentType = APPLICATION_OCTET_STREAM;
            }
            this.writeFileField(fieldName, file, contentType, filename);
        }
        return this;
    }

    public MultipartFormDataHelper serializeFileFields(String fieldName, List<BinaryData> files, List<String> contentTypes, List<String> filenames) {
        if (files != null) {
            for (int i = 0; i < files.size(); ++i) {
                BinaryData file = files.get(i);
                String contentType = contentTypes.get(i);
                if (CoreUtils.isNullOrEmpty(contentType)) {
                    contentType = APPLICATION_OCTET_STREAM;
                }
                String filename = filenames.get(i);
                this.writeFileField(fieldName, file, contentType, filename);
            }
        }
        return this;
    }

    public MultipartFormDataHelper end() {
        byte[] data = this.endMarker.getBytes(this.encoderCharset);
        this.appendBytes(data);
        this.requestBody = BinaryData.fromStream(this.requestDataStream, this.requestLength);
        this.requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, "multipart/form-data; boundary=" + this.boundary).setHeader(HttpHeaderName.CONTENT_LENGTH, String.valueOf(this.requestLength));
        return this;
    }

    private void writeFileField(String fieldName, BinaryData file, String contentType, String filename) {
        String contentDispositionFilename = "";
        if (!CoreUtils.isNullOrEmpty(filename)) {
            contentDispositionFilename = "; filename=\"" + MultipartFormDataHelper.escapeName(filename) + "\"";
        }
        String fileFieldPreamble = this.partSeparator + CRLF + "Content-Disposition: form-data; name=\"" + MultipartFormDataHelper.escapeName(fieldName) + "\"" + contentDispositionFilename + CRLF + "Content-Type: " + contentType + CRLF + CRLF;
        byte[] data = fileFieldPreamble.getBytes(this.encoderCharset);
        this.appendBytes(data);
        this.requestLength += file.getLength().longValue();
        this.requestDataStream = new SequenceInputStream(this.requestDataStream, file.toStream());
        data = CRLF.getBytes(this.encoderCharset);
        this.appendBytes(data);
    }

    private void appendBytes(byte[] bytes) {
        this.requestLength += (long)bytes.length;
        this.requestDataStream = new SequenceInputStream(this.requestDataStream, new ByteArrayInputStream(bytes));
    }

    private static String escapeName(String name) {
        return name.replace("\n", "%0A").replace("\r", "%0D").replace("\"", "%22");
    }
}

