/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation.accesshelpers;

import com.azure.ai.openai.models.PageableList;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

public final class PageableListAccessHelper {
    private static PageableListAccessor accessor;

    public static void setAccessor(PageableListAccessor pageableContentAccessor) {
        accessor = pageableContentAccessor;
    }

    public static <T> PageableList<T> create(List<T> data, String firstId, String lastId, boolean hasMore) {
        if (accessor == null) {
            new PageableList();
        }
        assert (accessor != null);
        return accessor.create(data, firstId, lastId, hasMore);
    }

    public static <T> PageableList<T> create(BinaryData json, Function<JsonReader, List<T>> dataHandler) throws IOException {
        JsonReader jsonReader = JsonProviders.createReader(json.toStream());
        return jsonReader.readObject(reader -> {
            List data = null;
            String firstId = null;
            String lastId = null;
            boolean hasMore = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data".equals(fieldName)) {
                    data = (List)dataHandler.apply((JsonReader)reader);
                    continue;
                }
                if ("first_id".equals(fieldName)) {
                    firstId = reader.getString();
                    continue;
                }
                if ("last_id".equals(fieldName)) {
                    lastId = reader.getString();
                    continue;
                }
                if ("has_more".equals(fieldName)) {
                    hasMore = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return PageableListAccessHelper.create(data, firstId, lastId, hasMore);
        });
    }

    private PageableListAccessHelper() {
    }

    public static interface PageableListAccessor {
        public <T> PageableList<T> create(List<T> var1, String var2, String var3, boolean var4);
    }
}

