/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation.models;

import com.azure.ai.openai.models.Batch;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class OpenAIPageableListOfBatch
implements JsonSerializable<OpenAIPageableListOfBatch> {
    private final String object = "list";
    private List<Batch> data;
    private String firstId;
    private String lastId;
    private Boolean hasMore;

    public String getObject() {
        return this.object;
    }

    public List<Batch> getData() {
        return this.data;
    }

    public String getFirstId() {
        return this.firstId;
    }

    public String getLastId() {
        return this.lastId;
    }

    public Boolean isHasMore() {
        return this.hasMore;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("first_id", this.firstId);
        jsonWriter.writeStringField("last_id", this.lastId);
        jsonWriter.writeBooleanField("has_more", this.hasMore);
        return jsonWriter.writeEndObject();
    }

    public static OpenAIPageableListOfBatch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenAIPageableListOfBatch deserializedOpenAIPageableListOfBatch = new OpenAIPageableListOfBatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data".equals(fieldName)) {
                    List<Batch> data = reader.readArray(reader1 -> Batch.fromJson(reader1));
                    deserializedOpenAIPageableListOfBatch.data = data;
                    continue;
                }
                if ("first_id".equals(fieldName)) {
                    deserializedOpenAIPageableListOfBatch.firstId = reader.getString();
                    continue;
                }
                if ("last_id".equals(fieldName)) {
                    deserializedOpenAIPageableListOfBatch.lastId = reader.getString();
                    continue;
                }
                if ("has_more".equals(fieldName)) {
                    deserializedOpenAIPageableListOfBatch.hasMore = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenAIPageableListOfBatch;
        });
    }

    private OpenAIPageableListOfBatch() {
    }
}

