/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class AudioTranscriptionSegment
implements JsonSerializable<AudioTranscriptionSegment> {
    private final int id;
    private final double start;
    private final double end;
    private final String text;
    private final double temperature;
    private final double avgLogprob;
    private final double compressionRatio;
    private final double noSpeechProb;
    private final List<Integer> tokens;
    private final int seek;

    private AudioTranscriptionSegment(int id, Duration start, Duration end, String text, double temperature, double avgLogprob, double compressionRatio, double noSpeechProb, List<Integer> tokens, int seek) {
        this.id = id;
        this.start = start == null ? 0.0 : (double)start.toNanos() / 1.0E9;
        this.end = end == null ? 0.0 : (double)end.toNanos() / 1.0E9;
        this.text = text;
        this.temperature = temperature;
        this.avgLogprob = avgLogprob;
        this.compressionRatio = compressionRatio;
        this.noSpeechProb = noSpeechProb;
        this.tokens = tokens;
        this.seek = seek;
    }

    public int getId() {
        return this.id;
    }

    public Duration getStart() {
        return Duration.ofNanos((long)(this.start * 1.0E9));
    }

    public Duration getEnd() {
        return Duration.ofNanos((long)(this.end * 1.0E9));
    }

    public String getText() {
        return this.text;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getAvgLogprob() {
        return this.avgLogprob;
    }

    public double getCompressionRatio() {
        return this.compressionRatio;
    }

    public double getNoSpeechProb() {
        return this.noSpeechProb;
    }

    public List<Integer> getTokens() {
        return this.tokens;
    }

    public int getSeek() {
        return this.seek;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.id);
        jsonWriter.writeDoubleField("start", this.start);
        jsonWriter.writeDoubleField("end", this.end);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeDoubleField("temperature", this.temperature);
        jsonWriter.writeDoubleField("avg_logprob", this.avgLogprob);
        jsonWriter.writeDoubleField("compression_ratio", this.compressionRatio);
        jsonWriter.writeDoubleField("no_speech_prob", this.noSpeechProb);
        jsonWriter.writeArrayField("tokens", this.tokens, (writer, element) -> writer.writeInt((int)element));
        jsonWriter.writeIntField("seek", this.seek);
        return jsonWriter.writeEndObject();
    }

    public static AudioTranscriptionSegment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int id = 0;
            Duration start = null;
            Duration end = null;
            String text = null;
            double temperature = 0.0;
            double avgLogprob = 0.0;
            double compressionRatio = 0.0;
            double noSpeechProb = 0.0;
            List<Integer> tokens = null;
            int seek = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    continue;
                }
                if ("start".equals(fieldName)) {
                    start = Duration.ofNanos((long)(reader.getDouble() * 1.0E9));
                    continue;
                }
                if ("end".equals(fieldName)) {
                    end = Duration.ofNanos((long)(reader.getDouble() * 1.0E9));
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = reader.getDouble();
                    continue;
                }
                if ("avg_logprob".equals(fieldName)) {
                    avgLogprob = reader.getDouble();
                    continue;
                }
                if ("compression_ratio".equals(fieldName)) {
                    compressionRatio = reader.getDouble();
                    continue;
                }
                if ("no_speech_prob".equals(fieldName)) {
                    noSpeechProb = reader.getDouble();
                    continue;
                }
                if ("tokens".equals(fieldName)) {
                    tokens = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("seek".equals(fieldName)) {
                    seek = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new AudioTranscriptionSegment(id, start, end, text, temperature, avgLogprob, compressionRatio, noSpeechProb, tokens, seek);
        });
    }
}

