/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class AudioTranscriptionWord
implements JsonSerializable<AudioTranscriptionWord> {
    private final String word;
    private final double start;
    private final double end;

    public String getWord() {
        return this.word;
    }

    public Duration getStart() {
        return Duration.ofNanos((long)(this.start * 1.0E9));
    }

    public Duration getEnd() {
        return Duration.ofNanos((long)(this.end * 1.0E9));
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("word", this.word);
        jsonWriter.writeDoubleField("start", this.start);
        jsonWriter.writeDoubleField("end", this.end);
        return jsonWriter.writeEndObject();
    }

    public static AudioTranscriptionWord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String word = null;
            Duration start = null;
            Duration end = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("word".equals(fieldName)) {
                    word = reader.getString();
                    continue;
                }
                if ("start".equals(fieldName)) {
                    start = Duration.ofNanos((long)(reader.getDouble() * 1.0E9));
                    continue;
                }
                if ("end".equals(fieldName)) {
                    end = Duration.ofNanos((long)(reader.getDouble() * 1.0E9));
                    continue;
                }
                reader.skipChildren();
            }
            return new AudioTranscriptionWord(word, start, end);
        });
    }

    private AudioTranscriptionWord(String word, Duration start, Duration end) {
        this.word = word;
        this.start = start == null ? 0.0 : (double)start.toNanos() / 1.0E9;
        this.end = end == null ? 0.0 : (double)end.toNanos() / 1.0E9;
    }
}

