/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AudioTaskLabel;
import com.azure.ai.openai.models.AudioTranslationSegment;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class AudioTranslation
implements JsonSerializable<AudioTranslation> {
    private final String text;
    private AudioTaskLabel task;
    private String language;
    private Double duration;
    private List<AudioTranslationSegment> segments;

    private AudioTranslation(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public AudioTaskLabel getTask() {
        return this.task;
    }

    public String getLanguage() {
        return this.language;
    }

    public Duration getDuration() {
        if (this.duration == null) {
            return null;
        }
        return Duration.ofNanos((long)(this.duration * 1.0E9));
    }

    public List<AudioTranslationSegment> getSegments() {
        return this.segments;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("task", this.task == null ? null : this.task.toString());
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeNumberField("duration", this.duration);
        jsonWriter.writeArrayField("segments", this.segments, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static AudioTranslation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            AudioTaskLabel task = null;
            String language = null;
            Double duration = null;
            List<AudioTranslationSegment> segments = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("task".equals(fieldName)) {
                    task = AudioTaskLabel.fromString(reader.getString());
                    continue;
                }
                if ("language".equals(fieldName)) {
                    language = reader.getString();
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    duration = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("segments".equals(fieldName)) {
                    segments = reader.readArray(reader1 -> AudioTranslationSegment.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            AudioTranslation deserializedAudioTranslation = new AudioTranslation(text);
            deserializedAudioTranslation.task = task;
            deserializedAudioTranslation.language = language;
            deserializedAudioTranslation.duration = duration;
            deserializedAudioTranslation.segments = segments;
            return deserializedAudioTranslation;
        });
    }
}

