/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureChatExtensionType;
import com.azure.ai.openai.models.AzureCosmosDBChatExtensionConfiguration;
import com.azure.ai.openai.models.AzureSearchChatExtensionConfiguration;
import com.azure.ai.openai.models.ElasticsearchChatExtensionConfiguration;
import com.azure.ai.openai.models.MongoDBChatExtensionConfiguration;
import com.azure.ai.openai.models.PineconeChatExtensionConfiguration;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class AzureChatExtensionConfiguration
implements JsonSerializable<AzureChatExtensionConfiguration> {
    private AzureChatExtensionType type = AzureChatExtensionType.fromString("AzureChatExtensionConfiguration");

    public AzureChatExtensionType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureChatExtensionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                AzureChatExtensionConfiguration azureChatExtensionConfiguration;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("azure_search".equals(discriminatorValue)) {
                    azureChatExtensionConfiguration = AzureSearchChatExtensionConfiguration.fromJson(readerToUse.reset());
                    return azureChatExtensionConfiguration;
                }
                if ("azure_cosmos_db".equals(discriminatorValue)) {
                    azureChatExtensionConfiguration = AzureCosmosDBChatExtensionConfiguration.fromJson(readerToUse.reset());
                    return azureChatExtensionConfiguration;
                }
                if ("elasticsearch".equals(discriminatorValue)) {
                    azureChatExtensionConfiguration = ElasticsearchChatExtensionConfiguration.fromJson(readerToUse.reset());
                    return azureChatExtensionConfiguration;
                }
                if ("mongo_db".equals(discriminatorValue)) {
                    azureChatExtensionConfiguration = MongoDBChatExtensionConfiguration.fromJson(readerToUse.reset());
                    return azureChatExtensionConfiguration;
                }
                if ("pinecone".equals(discriminatorValue)) {
                    azureChatExtensionConfiguration = PineconeChatExtensionConfiguration.fromJson(readerToUse.reset());
                    return azureChatExtensionConfiguration;
                }
                azureChatExtensionConfiguration = AzureChatExtensionConfiguration.fromJsonKnownDiscriminator(readerToUse.reset());
                return azureChatExtensionConfiguration;
            }
        });
    }

    static AzureChatExtensionConfiguration fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureChatExtensionConfiguration deserializedAzureChatExtensionConfiguration = new AzureChatExtensionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedAzureChatExtensionConfiguration.type = AzureChatExtensionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureChatExtensionConfiguration;
        });
    }
}

