/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AzureCosmosDBFieldMappingOptions
implements JsonSerializable<AzureCosmosDBFieldMappingOptions> {
    private final List<String> vectorFields;
    private String titleField;
    private String urlField;
    private String filepathField;
    private final List<String> contentFields;
    private String contentFieldsSeparator;

    public List<String> getVectorFields() {
        return this.vectorFields;
    }

    public AzureCosmosDBFieldMappingOptions(List<String> contentFields, List<String> vectorFields) {
        this.contentFields = contentFields;
        this.vectorFields = vectorFields;
    }

    public String getTitleField() {
        return this.titleField;
    }

    public AzureCosmosDBFieldMappingOptions setTitleField(String titleField) {
        this.titleField = titleField;
        return this;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public AzureCosmosDBFieldMappingOptions setUrlField(String urlField) {
        this.urlField = urlField;
        return this;
    }

    public String getFilepathField() {
        return this.filepathField;
    }

    public AzureCosmosDBFieldMappingOptions setFilepathField(String filepathField) {
        this.filepathField = filepathField;
        return this;
    }

    public List<String> getContentFields() {
        return this.contentFields;
    }

    public String getContentFieldsSeparator() {
        return this.contentFieldsSeparator;
    }

    public AzureCosmosDBFieldMappingOptions setContentFieldsSeparator(String contentFieldsSeparator) {
        this.contentFieldsSeparator = contentFieldsSeparator;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("content_fields", this.contentFields, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("vector_fields", this.vectorFields, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("title_field", this.titleField);
        jsonWriter.writeStringField("url_field", this.urlField);
        jsonWriter.writeStringField("filepath_field", this.filepathField);
        jsonWriter.writeStringField("content_fields_separator", this.contentFieldsSeparator);
        return jsonWriter.writeEndObject();
    }

    public static AzureCosmosDBFieldMappingOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<String> contentFields = null;
            List<String> vectorFields = null;
            String titleField = null;
            String urlField = null;
            String filepathField = null;
            String contentFieldsSeparator = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content_fields".equals(fieldName)) {
                    contentFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("vector_fields".equals(fieldName)) {
                    vectorFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("title_field".equals(fieldName)) {
                    titleField = reader.getString();
                    continue;
                }
                if ("url_field".equals(fieldName)) {
                    urlField = reader.getString();
                    continue;
                }
                if ("filepath_field".equals(fieldName)) {
                    filepathField = reader.getString();
                    continue;
                }
                if ("content_fields_separator".equals(fieldName)) {
                    contentFieldsSeparator = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            AzureCosmosDBFieldMappingOptions deserializedAzureCosmosDBFieldMappingOptions = new AzureCosmosDBFieldMappingOptions(contentFields, vectorFields);
            deserializedAzureCosmosDBFieldMappingOptions.titleField = titleField;
            deserializedAzureCosmosDBFieldMappingOptions.urlField = urlField;
            deserializedAzureCosmosDBFieldMappingOptions.filepathField = filepathField;
            deserializedAzureCosmosDBFieldMappingOptions.contentFieldsSeparator = contentFieldsSeparator;
            return deserializedAzureCosmosDBFieldMappingOptions;
        });
    }
}

