/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureChatExtensionConfiguration;
import com.azure.ai.openai.models.AzureChatExtensionType;
import com.azure.ai.openai.models.AzureSearchChatExtensionParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureSearchChatExtensionConfiguration
extends AzureChatExtensionConfiguration {
    private final AzureSearchChatExtensionParameters parameters;
    private AzureChatExtensionType type = AzureChatExtensionType.AZURE_SEARCH;

    public AzureSearchChatExtensionConfiguration(AzureSearchChatExtensionParameters parameters) {
        this.parameters = parameters;
    }

    public AzureSearchChatExtensionParameters getParameters() {
        return this.parameters;
    }

    @Override
    public AzureChatExtensionType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", this.parameters);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureSearchChatExtensionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureSearchChatExtensionParameters parameters = null;
            AzureChatExtensionType type = AzureChatExtensionType.AZURE_SEARCH;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    parameters = AzureSearchChatExtensionParameters.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = AzureChatExtensionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            AzureSearchChatExtensionConfiguration deserializedAzureSearchChatExtensionConfiguration = new AzureSearchChatExtensionConfiguration(parameters);
            deserializedAzureSearchChatExtensionConfiguration.type = type;
            return deserializedAzureSearchChatExtensionConfiguration;
        });
    }
}

