/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.FunctionCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatCompletionsFunctionToolCall
extends ChatCompletionsToolCall {
    private final FunctionCall function;
    private String type = "function";

    public ChatCompletionsFunctionToolCall(String id, FunctionCall function) {
        super(id);
        this.function = function;
    }

    public FunctionCall getFunction() {
        return this.function;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeJsonField("function", this.function);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static ChatCompletionsFunctionToolCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            FunctionCall function = null;
            String type = "function";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("function".equals(fieldName)) {
                    function = FunctionCall.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatCompletionsFunctionToolCall deserializedChatCompletionsFunctionToolCall = new ChatCompletionsFunctionToolCall(id, function);
            deserializedChatCompletionsFunctionToolCall.type = type;
            return deserializedChatCompletionsFunctionToolCall;
        });
    }

    @Override
    public String getType() {
        return this.type;
    }
}

