/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatCompletionsFunctionToolDefinitionFunction
implements JsonSerializable<ChatCompletionsFunctionToolDefinitionFunction> {
    private String description;
    private final String name;
    private BinaryData parameters;
    private Boolean strict;

    public ChatCompletionsFunctionToolDefinitionFunction(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public ChatCompletionsFunctionToolDefinitionFunction setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BinaryData getParameters() {
        return this.parameters;
    }

    public ChatCompletionsFunctionToolDefinitionFunction setParameters(BinaryData parameters) {
        this.parameters = parameters;
        return this;
    }

    public Boolean isStrict() {
        return this.strict;
    }

    public ChatCompletionsFunctionToolDefinitionFunction setStrict(Boolean strict) {
        this.strict = strict;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeRawField("parameters", this.parameters.toString());
        jsonWriter.writeBooleanField("strict", this.strict);
        return jsonWriter.writeEndObject();
    }

    public static ChatCompletionsFunctionToolDefinitionFunction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            String description = null;
            BinaryData parameters = null;
            Boolean strict = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    parameters = BinaryData.fromObject(reader.readUntyped());
                    continue;
                }
                if ("strict".equals(fieldName)) {
                    strict = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            ChatCompletionsFunctionToolDefinitionFunction deserializedChatCompletionsFunctionToolDefinitionFunction = new ChatCompletionsFunctionToolDefinitionFunction(name);
            deserializedChatCompletionsFunctionToolDefinitionFunction.description = description;
            deserializedChatCompletionsFunctionToolDefinitionFunction.parameters = parameters;
            deserializedChatCompletionsFunctionToolDefinitionFunction.strict = strict;
            return deserializedChatCompletionsFunctionToolDefinitionFunction;
        });
    }
}

