/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatMessageContentItem;
import com.azure.ai.openai.models.ChatMessageImageUrl;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatMessageImageContentItem
extends ChatMessageContentItem {
    private final ChatMessageImageUrl imageUrl;
    private String type = "image_url";

    public ChatMessageImageContentItem(ChatMessageImageUrl imageUrl) {
        this.imageUrl = imageUrl;
    }

    public ChatMessageImageUrl getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image_url", this.imageUrl);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static ChatMessageImageContentItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatMessageImageUrl imageUrl = null;
            String type = "image_url";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image_url".equals(fieldName)) {
                    imageUrl = ChatMessageImageUrl.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatMessageImageContentItem deserializedChatMessageImageContentItem = new ChatMessageImageContentItem(imageUrl);
            deserializedChatMessageImageContentItem.type = type;
            return deserializedChatMessageImageContentItem;
        });
    }
}

