/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatMessageImageDetailLevel;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatMessageImageUrl
implements JsonSerializable<ChatMessageImageUrl> {
    private final String url;
    private ChatMessageImageDetailLevel detail;

    public ChatMessageImageUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public ChatMessageImageDetailLevel getDetail() {
        return this.detail;
    }

    public ChatMessageImageUrl setDetail(ChatMessageImageDetailLevel detail) {
        this.detail = detail;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("detail", this.detail == null ? null : this.detail.toString());
        return jsonWriter.writeEndObject();
    }

    public static ChatMessageImageUrl fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String url = null;
            ChatMessageImageDetailLevel detail = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("detail".equals(fieldName)) {
                    detail = ChatMessageImageDetailLevel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ChatMessageImageUrl deserializedChatMessageImageUrl = new ChatMessageImageUrl(url);
            deserializedChatMessageImageUrl.detail = detail;
            return deserializedChatMessageImageUrl;
        });
    }
}

