/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatMessageContentItem;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatMessageTextContentItem
extends ChatMessageContentItem {
    private final String text;
    private String type = "text";

    public ChatMessageTextContentItem(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static ChatMessageTextContentItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            String type = "text";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatMessageTextContentItem deserializedChatMessageTextContentItem = new ChatMessageTextContentItem(text);
            deserializedChatMessageTextContentItem.type = type;
            return deserializedChatMessageTextContentItem;
        });
    }
}

