/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatTokenLogProbabilityInfo
implements JsonSerializable<ChatTokenLogProbabilityInfo> {
    private final String token;
    private final double logprob;
    private final List<Integer> bytes;

    private ChatTokenLogProbabilityInfo(String token, double logprob, List<Integer> bytes) {
        this.token = token;
        this.logprob = logprob;
        this.bytes = bytes;
    }

    public String getToken() {
        return this.token;
    }

    public double getLogprob() {
        return this.logprob;
    }

    public List<Integer> getBytes() {
        return this.bytes;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("token", this.token);
        jsonWriter.writeDoubleField("logprob", this.logprob);
        jsonWriter.writeArrayField("bytes", this.bytes, (writer, element) -> writer.writeInt((int)element));
        return jsonWriter.writeEndObject();
    }

    public static ChatTokenLogProbabilityInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String token = null;
            double logprob = 0.0;
            List<Integer> bytes = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("token".equals(fieldName)) {
                    token = reader.getString();
                    continue;
                }
                if ("logprob".equals(fieldName)) {
                    logprob = reader.getDouble();
                    continue;
                }
                if ("bytes".equals(fieldName)) {
                    bytes = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                reader.skipChildren();
            }
            return new ChatTokenLogProbabilityInfo(token, logprob, bytes);
        });
    }
}

