/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.CompletionsFinishReason;
import com.azure.ai.openai.models.CompletionsLogProbabilityModel;
import com.azure.ai.openai.models.ContentFilterResultsForChoice;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Choice
implements JsonSerializable<Choice> {
    private final String text;
    private final int index;
    private final CompletionsLogProbabilityModel logprobs;
    private final CompletionsFinishReason finishReason;
    private ContentFilterResultsForChoice contentFilterResults;

    private Choice(String text, int index, CompletionsLogProbabilityModel logprobs, CompletionsFinishReason finishReason) {
        this.text = text;
        this.index = index;
        this.logprobs = logprobs;
        this.finishReason = finishReason;
    }

    public String getText() {
        return this.text;
    }

    public int getIndex() {
        return this.index;
    }

    public CompletionsLogProbabilityModel getLogprobs() {
        return this.logprobs;
    }

    public CompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }

    public ContentFilterResultsForChoice getContentFilterResults() {
        return this.contentFilterResults;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeJsonField("logprobs", this.logprobs);
        jsonWriter.writeStringField("finish_reason", this.finishReason == null ? null : this.finishReason.toString());
        jsonWriter.writeJsonField("content_filter_results", this.contentFilterResults);
        return jsonWriter.writeEndObject();
    }

    public static Choice fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            int index = 0;
            CompletionsLogProbabilityModel logprobs = null;
            CompletionsFinishReason finishReason = null;
            ContentFilterResultsForChoice contentFilterResults = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("logprobs".equals(fieldName)) {
                    logprobs = CompletionsLogProbabilityModel.fromJson(reader);
                    continue;
                }
                if ("finish_reason".equals(fieldName)) {
                    finishReason = CompletionsFinishReason.fromString(reader.getString());
                    continue;
                }
                if ("content_filter_results".equals(fieldName)) {
                    contentFilterResults = ContentFilterResultsForChoice.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            Choice deserializedChoice = new Choice(text, index, logprobs, finishReason);
            deserializedChoice.contentFilterResults = contentFilterResults;
            return deserializedChoice;
        });
    }
}

