/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CompleteUploadRequest
implements JsonSerializable<CompleteUploadRequest> {
    private final List<String> partIds;
    private String md5;

    public CompleteUploadRequest(List<String> partIds) {
        this.partIds = partIds;
    }

    public List<String> getPartIds() {
        return this.partIds;
    }

    public String getMd5() {
        return this.md5;
    }

    public CompleteUploadRequest setMd5(String md5) {
        this.md5 = md5;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("part_ids", this.partIds, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("md5", this.md5);
        return jsonWriter.writeEndObject();
    }

    public static CompleteUploadRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<String> partIds = null;
            String md5 = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("part_ids".equals(fieldName)) {
                    partIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("md5".equals(fieldName)) {
                    md5 = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            CompleteUploadRequest deserializedCompleteUploadRequest = new CompleteUploadRequest(partIds);
            deserializedCompleteUploadRequest.md5 = md5;
            return deserializedCompleteUploadRequest;
        });
    }
}

