/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.Choice;
import com.azure.ai.openai.models.CompletionsUsage;
import com.azure.ai.openai.models.ContentFilterResultsForPrompt;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;

public final class Completions
implements JsonSerializable<Completions> {
    private final String id;
    private final List<Choice> choices;
    private final CompletionsUsage usage;
    private List<ContentFilterResultsForPrompt> promptFilterResults;
    private final long createdAt;
    private String systemFingerprint;

    public String getId() {
        return this.id;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public CompletionsUsage getUsage() {
        return this.usage;
    }

    public List<ContentFilterResultsForPrompt> getPromptFilterResults() {
        return this.promptFilterResults;
    }

    private Completions(String id, OffsetDateTime createdAt, List<Choice> choices, CompletionsUsage usage) {
        this.id = id;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.choices = choices;
        this.usage = usage;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeLongField("created", this.createdAt);
        jsonWriter.writeArrayField("choices", this.choices, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("usage", this.usage);
        jsonWriter.writeArrayField("prompt_filter_results", this.promptFilterResults, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("system_fingerprint", this.systemFingerprint);
        return jsonWriter.writeEndObject();
    }

    public static Completions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            List<Choice> choices = null;
            CompletionsUsage usage = null;
            List<ContentFilterResultsForPrompt> promptFilterResults = null;
            String systemFingerprint = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("choices".equals(fieldName)) {
                    choices = reader.readArray(reader1 -> Choice.fromJson(reader1));
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    usage = CompletionsUsage.fromJson(reader);
                    continue;
                }
                if ("prompt_filter_results".equals(fieldName)) {
                    promptFilterResults = reader.readArray(reader1 -> ContentFilterResultsForPrompt.fromJson(reader1));
                    continue;
                }
                if ("system_fingerprint".equals(fieldName)) {
                    systemFingerprint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            Completions deserializedCompletions = new Completions(id, createdAt, choices, usage);
            deserializedCompletions.promptFilterResults = promptFilterResults;
            deserializedCompletions.systemFingerprint = systemFingerprint;
            return deserializedCompletions;
        });
    }

    public String getSystemFingerprint() {
        return this.systemFingerprint;
    }
}

