/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ContentFilterCompletionTextSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ContentFilterCompletionTextSpanResult
implements JsonSerializable<ContentFilterCompletionTextSpanResult> {
    private final boolean filtered;
    private final boolean detected;
    private final List<ContentFilterCompletionTextSpan> details;

    private ContentFilterCompletionTextSpanResult(boolean filtered, boolean detected, List<ContentFilterCompletionTextSpan> details) {
        this.filtered = filtered;
        this.detected = detected;
        this.details = details;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean isDetected() {
        return this.detected;
    }

    public List<ContentFilterCompletionTextSpan> getDetails() {
        return this.details;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("filtered", this.filtered);
        jsonWriter.writeBooleanField("detected", this.detected);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ContentFilterCompletionTextSpanResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean filtered = false;
            boolean detected = false;
            List<ContentFilterCompletionTextSpan> details = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filtered".equals(fieldName)) {
                    filtered = reader.getBoolean();
                    continue;
                }
                if ("detected".equals(fieldName)) {
                    detected = reader.getBoolean();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> ContentFilterCompletionTextSpan.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new ContentFilterCompletionTextSpanResult(filtered, detected, details);
        });
    }
}

