/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ContentFilterBlocklistIdResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ContentFilterDetailedResults
implements JsonSerializable<ContentFilterDetailedResults> {
    private final boolean filtered;
    private final List<ContentFilterBlocklistIdResult> details;

    public boolean isFiltered() {
        return this.filtered;
    }

    public List<ContentFilterBlocklistIdResult> getDetails() {
        return this.details;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("filtered", this.filtered);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ContentFilterDetailedResults fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean filtered = false;
            List<ContentFilterBlocklistIdResult> details = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filtered".equals(fieldName)) {
                    filtered = reader.getBoolean();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> ContentFilterBlocklistIdResult.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new ContentFilterDetailedResults(filtered, details);
        });
    }

    private ContentFilterDetailedResults(boolean filtered, List<ContentFilterBlocklistIdResult> details) {
        this.filtered = filtered;
        this.details = details;
    }
}

