/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ContentFilterSeverity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ContentFilterResult
implements JsonSerializable<ContentFilterResult> {
    private final ContentFilterSeverity severity;
    private final boolean filtered;

    public ContentFilterSeverity getSeverity() {
        return this.severity;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    private ContentFilterResult(boolean filtered, ContentFilterSeverity severity) {
        this.filtered = filtered;
        this.severity = severity;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("filtered", this.filtered);
        jsonWriter.writeStringField("severity", this.severity == null ? null : this.severity.toString());
        return jsonWriter.writeEndObject();
    }

    public static ContentFilterResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean filtered = false;
            ContentFilterSeverity severity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filtered".equals(fieldName)) {
                    filtered = reader.getBoolean();
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    severity = ContentFilterSeverity.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new ContentFilterResult(filtered, severity);
        });
    }
}

