/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureChatExtensionConfiguration;
import com.azure.ai.openai.models.AzureChatExtensionType;
import com.azure.ai.openai.models.ElasticsearchChatExtensionParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ElasticsearchChatExtensionConfiguration
extends AzureChatExtensionConfiguration {
    private final ElasticsearchChatExtensionParameters parameters;
    private AzureChatExtensionType type = AzureChatExtensionType.ELASTICSEARCH;

    public ElasticsearchChatExtensionParameters getParameters() {
        return this.parameters;
    }

    public ElasticsearchChatExtensionConfiguration(ElasticsearchChatExtensionParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public AzureChatExtensionType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", this.parameters);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ElasticsearchChatExtensionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ElasticsearchChatExtensionParameters parameters = null;
            AzureChatExtensionType type = AzureChatExtensionType.ELASTICSEARCH;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    parameters = ElasticsearchChatExtensionParameters.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = AzureChatExtensionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ElasticsearchChatExtensionConfiguration deserializedElasticsearchChatExtensionConfiguration = new ElasticsearchChatExtensionConfiguration(parameters);
            deserializedElasticsearchChatExtensionConfiguration.type = type;
            return deserializedElasticsearchChatExtensionConfiguration;
        });
    }
}

