/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ElasticsearchIndexFieldMappingOptions
implements JsonSerializable<ElasticsearchIndexFieldMappingOptions> {
    private String titleField;
    private String urlField;
    private String filepathField;
    private List<String> contentFields;
    private String contentFieldsSeparator;
    private List<String> vectorFields;

    public String getTitleField() {
        return this.titleField;
    }

    public ElasticsearchIndexFieldMappingOptions setTitleField(String titleField) {
        this.titleField = titleField;
        return this;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public ElasticsearchIndexFieldMappingOptions setUrlField(String urlField) {
        this.urlField = urlField;
        return this;
    }

    public String getFilepathField() {
        return this.filepathField;
    }

    public ElasticsearchIndexFieldMappingOptions setFilepathField(String filepathField) {
        this.filepathField = filepathField;
        return this;
    }

    public List<String> getContentFields() {
        return this.contentFields;
    }

    public ElasticsearchIndexFieldMappingOptions setContentFields(List<String> contentFields) {
        this.contentFields = contentFields;
        return this;
    }

    public String getContentFieldsSeparator() {
        return this.contentFieldsSeparator;
    }

    public ElasticsearchIndexFieldMappingOptions setContentFieldsSeparator(String contentFieldsSeparator) {
        this.contentFieldsSeparator = contentFieldsSeparator;
        return this;
    }

    public List<String> getVectorFields() {
        return this.vectorFields;
    }

    public ElasticsearchIndexFieldMappingOptions setVectorFields(List<String> vectorFields) {
        this.vectorFields = vectorFields;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title_field", this.titleField);
        jsonWriter.writeStringField("url_field", this.urlField);
        jsonWriter.writeStringField("filepath_field", this.filepathField);
        jsonWriter.writeArrayField("content_fields", this.contentFields, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("content_fields_separator", this.contentFieldsSeparator);
        jsonWriter.writeArrayField("vector_fields", this.vectorFields, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static ElasticsearchIndexFieldMappingOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ElasticsearchIndexFieldMappingOptions deserializedElasticsearchIndexFieldMappingOptions = new ElasticsearchIndexFieldMappingOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("title_field".equals(fieldName)) {
                    deserializedElasticsearchIndexFieldMappingOptions.titleField = reader.getString();
                    continue;
                }
                if ("url_field".equals(fieldName)) {
                    deserializedElasticsearchIndexFieldMappingOptions.urlField = reader.getString();
                    continue;
                }
                if ("filepath_field".equals(fieldName)) {
                    deserializedElasticsearchIndexFieldMappingOptions.filepathField = reader.getString();
                    continue;
                }
                if ("content_fields".equals(fieldName)) {
                    List<String> contentFields = reader.readArray(reader1 -> reader1.getString());
                    deserializedElasticsearchIndexFieldMappingOptions.contentFields = contentFields;
                    continue;
                }
                if ("content_fields_separator".equals(fieldName)) {
                    deserializedElasticsearchIndexFieldMappingOptions.contentFieldsSeparator = reader.getString();
                    continue;
                }
                if ("vector_fields".equals(fieldName)) {
                    List<String> vectorFields = reader.readArray(reader1 -> reader1.getString());
                    deserializedElasticsearchIndexFieldMappingOptions.vectorFields = vectorFields;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticsearchIndexFieldMappingOptions;
        });
    }
}

