/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.EmbeddingEncodingFormat;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class EmbeddingsOptions
implements JsonSerializable<EmbeddingsOptions> {
    private String user;
    private String model;
    private final List<String> input;
    private String inputType;
    private Integer dimensions;
    private EmbeddingEncodingFormat encodingFormat;

    public EmbeddingsOptions(List<String> input) {
        this.input = input;
    }

    public String getUser() {
        return this.user;
    }

    public EmbeddingsOptions setUser(String user) {
        this.user = user;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public EmbeddingsOptions setModel(String model) {
        this.model = model;
        return this;
    }

    public List<String> getInput() {
        return this.input;
    }

    public String getInputType() {
        return this.inputType;
    }

    public EmbeddingsOptions setInputType(String inputType) {
        this.inputType = inputType;
        return this;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public EmbeddingsOptions setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    EmbeddingEncodingFormat getEncodingFormat() {
        return this.encodingFormat;
    }

    EmbeddingsOptions setEncodingFormat(EmbeddingEncodingFormat encodingFormat) {
        this.encodingFormat = encodingFormat;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("input", this.input, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("user", this.user);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("encoding_format", this.encodingFormat == null ? null : this.encodingFormat.toString());
        jsonWriter.writeNumberField("dimensions", this.dimensions);
        jsonWriter.writeStringField("input_type", this.inputType);
        return jsonWriter.writeEndObject();
    }

    public static EmbeddingsOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<String> input = null;
            String user = null;
            String model = null;
            EmbeddingEncodingFormat encodingFormat = null;
            Integer dimensions = null;
            String inputType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("input".equals(fieldName)) {
                    input = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("user".equals(fieldName)) {
                    user = reader.getString();
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("encoding_format".equals(fieldName)) {
                    encodingFormat = EmbeddingEncodingFormat.fromString(reader.getString());
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    dimensions = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("input_type".equals(fieldName)) {
                    inputType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            EmbeddingsOptions deserializedEmbeddingsOptions = new EmbeddingsOptions(input);
            deserializedEmbeddingsOptions.user = user;
            deserializedEmbeddingsOptions.model = model;
            deserializedEmbeddingsOptions.encodingFormat = encodingFormat;
            deserializedEmbeddingsOptions.dimensions = dimensions;
            deserializedEmbeddingsOptions.inputType = inputType;
            return deserializedEmbeddingsOptions;
        });
    }
}

