/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FileDeletionStatus
implements JsonSerializable<FileDeletionStatus> {
    private final String id;
    private final boolean deleted;
    private final String object = "file";

    private FileDeletionStatus(String id, boolean deleted) {
        this.id = id;
        this.deleted = deleted;
    }

    public String getId() {
        return this.id;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String getObject() {
        return this.object;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeBooleanField("deleted", this.deleted);
        jsonWriter.writeStringField("object", this.object);
        return jsonWriter.writeEndObject();
    }

    public static FileDeletionStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            boolean deleted = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("deleted".equals(fieldName)) {
                    deleted = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return new FileDeletionStatus(id, deleted);
        });
    }
}

