/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FunctionDefinition
implements JsonSerializable<FunctionDefinition> {
    private final String name;
    private String description;
    private BinaryData parameters;

    public FunctionDefinition(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public FunctionDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    public BinaryData getParameters() {
        return this.parameters;
    }

    public FunctionDefinition setParameters(BinaryData parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeRawField("parameters", this.parameters.toString());
        return jsonWriter.writeEndObject();
    }

    public static FunctionDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            String description = null;
            BinaryData parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    parameters = BinaryData.fromObject(reader.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            FunctionDefinition deserializedFunctionDefinition = new FunctionDefinition(name);
            deserializedFunctionDefinition.description = description;
            deserializedFunctionDefinition.parameters = parameters;
            return deserializedFunctionDefinition;
        });
    }
}

