/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ImageGenerationContentFilterResults;
import com.azure.ai.openai.models.ImageGenerationPromptFilterResults;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImageGenerationData
implements JsonSerializable<ImageGenerationData> {
    private String url;
    private String base64Data;
    private String revisedPrompt;
    private ImageGenerationContentFilterResults contentFilterResults;
    private ImageGenerationPromptFilterResults promptFilterResults;

    private ImageGenerationData() {
    }

    public String getUrl() {
        return this.url;
    }

    public String getBase64Data() {
        return this.base64Data;
    }

    public String getRevisedPrompt() {
        return this.revisedPrompt;
    }

    public ImageGenerationContentFilterResults getContentFilterResults() {
        return this.contentFilterResults;
    }

    public ImageGenerationPromptFilterResults getPromptFilterResults() {
        return this.promptFilterResults;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("b64_json", this.base64Data);
        jsonWriter.writeJsonField("content_filter_results", this.contentFilterResults);
        jsonWriter.writeStringField("revised_prompt", this.revisedPrompt);
        jsonWriter.writeJsonField("prompt_filter_results", this.promptFilterResults);
        return jsonWriter.writeEndObject();
    }

    public static ImageGenerationData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageGenerationData deserializedImageGenerationData = new ImageGenerationData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedImageGenerationData.url = reader.getString();
                    continue;
                }
                if ("b64_json".equals(fieldName)) {
                    deserializedImageGenerationData.base64Data = reader.getString();
                    continue;
                }
                if ("content_filter_results".equals(fieldName)) {
                    deserializedImageGenerationData.contentFilterResults = ImageGenerationContentFilterResults.fromJson(reader);
                    continue;
                }
                if ("revised_prompt".equals(fieldName)) {
                    deserializedImageGenerationData.revisedPrompt = reader.getString();
                    continue;
                }
                if ("prompt_filter_results".equals(fieldName)) {
                    deserializedImageGenerationData.promptFilterResults = ImageGenerationPromptFilterResults.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageGenerationData;
        });
    }
}

