/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ContentFilterDetailedResults;
import com.azure.ai.openai.models.ContentFilterDetectionResult;
import com.azure.ai.openai.models.ContentFilterResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImageGenerationPromptFilterResults
implements JsonSerializable<ImageGenerationPromptFilterResults> {
    private ContentFilterResult sexual;
    private ContentFilterResult violence;
    private ContentFilterResult hate;
    private ContentFilterResult selfHarm;
    private ContentFilterDetectionResult profanity;
    private ContentFilterDetectionResult jailbreak;
    private ContentFilterDetailedResults customBlocklists;

    private ImageGenerationPromptFilterResults() {
    }

    public ContentFilterResult getSexual() {
        return this.sexual;
    }

    public ContentFilterResult getViolence() {
        return this.violence;
    }

    public ContentFilterResult getHate() {
        return this.hate;
    }

    public ContentFilterResult getSelfHarm() {
        return this.selfHarm;
    }

    public ContentFilterDetectionResult getProfanity() {
        return this.profanity;
    }

    public ContentFilterDetectionResult getJailbreak() {
        return this.jailbreak;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sexual", this.sexual);
        jsonWriter.writeJsonField("violence", this.violence);
        jsonWriter.writeJsonField("hate", this.hate);
        jsonWriter.writeJsonField("self_harm", this.selfHarm);
        jsonWriter.writeJsonField("profanity", this.profanity);
        jsonWriter.writeJsonField("jailbreak", this.jailbreak);
        jsonWriter.writeJsonField("custom_blocklists", this.customBlocklists);
        return jsonWriter.writeEndObject();
    }

    public static ImageGenerationPromptFilterResults fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageGenerationPromptFilterResults deserializedImageGenerationPromptFilterResults = new ImageGenerationPromptFilterResults();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sexual".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.sexual = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("violence".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.violence = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("hate".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.hate = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("self_harm".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.selfHarm = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("profanity".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.profanity = ContentFilterDetectionResult.fromJson(reader);
                    continue;
                }
                if ("jailbreak".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.jailbreak = ContentFilterDetectionResult.fromJson(reader);
                    continue;
                }
                if ("custom_blocklists".equals(fieldName)) {
                    deserializedImageGenerationPromptFilterResults.customBlocklists = ContentFilterDetailedResults.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageGenerationPromptFilterResults;
        });
    }

    public ContentFilterDetailedResults getCustomBlocklists() {
        return this.customBlocklists;
    }
}

