/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.MongoDBChatExtensionParametersFieldsMapping;
import com.azure.ai.openai.models.OnYourDataContextProperty;
import com.azure.ai.openai.models.OnYourDataUsernameAndPasswordAuthenticationOptions;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class MongoDBChatExtensionParameters
implements JsonSerializable<MongoDBChatExtensionParameters> {
    private OnYourDataUsernameAndPasswordAuthenticationOptions authentication;
    private Integer topNDocuments;
    private Boolean inScope;
    private Integer strictness;
    private Integer maxSearchQueries;
    private Boolean allowPartialResult;
    private List<OnYourDataContextProperty> includeContexts;
    private final String endpoint;
    private final String collectionName;
    private final String databaseName;
    private final String appName;
    private final MongoDBChatExtensionParametersFieldsMapping fieldsMapping;
    private final BinaryData embeddingDependency;
    private final String indexName;

    public OnYourDataUsernameAndPasswordAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    public MongoDBChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    public Boolean isInScope() {
        return this.inScope;
    }

    public MongoDBChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    public Integer getStrictness() {
        return this.strictness;
    }

    public MongoDBChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    public Integer getMaxSearchQueries() {
        return this.maxSearchQueries;
    }

    public MongoDBChatExtensionParameters setMaxSearchQueries(Integer maxSearchQueries) {
        this.maxSearchQueries = maxSearchQueries;
        return this;
    }

    public Boolean isAllowPartialResult() {
        return this.allowPartialResult;
    }

    public MongoDBChatExtensionParameters setAllowPartialResult(Boolean allowPartialResult) {
        this.allowPartialResult = allowPartialResult;
        return this;
    }

    public List<OnYourDataContextProperty> getIncludeContexts() {
        return this.includeContexts;
    }

    public MongoDBChatExtensionParameters setIncludeContexts(List<OnYourDataContextProperty> includeContexts) {
        this.includeContexts = includeContexts;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getAppName() {
        return this.appName;
    }

    public MongoDBChatExtensionParametersFieldsMapping getFieldsMapping() {
        return this.fieldsMapping;
    }

    public BinaryData getEmbeddingDependency() {
        return this.embeddingDependency;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeStringField("collection_name", this.collectionName);
        jsonWriter.writeStringField("database_name", this.databaseName);
        jsonWriter.writeStringField("app_name", this.appName);
        jsonWriter.writeStringField("index_name", this.indexName);
        jsonWriter.writeJsonField("fields_mapping", this.fieldsMapping);
        jsonWriter.writeFieldName("embedding_dependency");
        this.embeddingDependency.writeTo(jsonWriter);
        jsonWriter.writeNumberField("top_n_documents", this.topNDocuments);
        jsonWriter.writeBooleanField("in_scope", this.inScope);
        jsonWriter.writeNumberField("strictness", this.strictness);
        jsonWriter.writeNumberField("max_search_queries", this.maxSearchQueries);
        jsonWriter.writeBooleanField("allow_partial_result", this.allowPartialResult);
        jsonWriter.writeArrayField("include_contexts", this.includeContexts, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("authentication", this.authentication);
        return jsonWriter.writeEndObject();
    }

    public static MongoDBChatExtensionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String endpoint = null;
            String collectionName = null;
            String databaseName = null;
            String appName = null;
            String indexName = null;
            MongoDBChatExtensionParametersFieldsMapping fieldsMapping = null;
            BinaryData embeddingDependency = null;
            Integer topNDocuments = null;
            Boolean inScope = null;
            Integer strictness = null;
            Integer maxSearchQueries = null;
            Boolean allowPartialResult = null;
            List<OnYourDataContextProperty> includeContexts = null;
            OnYourDataUsernameAndPasswordAuthenticationOptions authentication = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    endpoint = reader.getString();
                    continue;
                }
                if ("collection_name".equals(fieldName)) {
                    collectionName = reader.getString();
                    continue;
                }
                if ("database_name".equals(fieldName)) {
                    databaseName = reader.getString();
                    continue;
                }
                if ("app_name".equals(fieldName)) {
                    appName = reader.getString();
                    continue;
                }
                if ("index_name".equals(fieldName)) {
                    indexName = reader.getString();
                    continue;
                }
                if ("fields_mapping".equals(fieldName)) {
                    fieldsMapping = MongoDBChatExtensionParametersFieldsMapping.fromJson(reader);
                    continue;
                }
                if ("embedding_dependency".equals(fieldName)) {
                    embeddingDependency = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                    continue;
                }
                if ("top_n_documents".equals(fieldName)) {
                    topNDocuments = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("in_scope".equals(fieldName)) {
                    inScope = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("strictness".equals(fieldName)) {
                    strictness = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("max_search_queries".equals(fieldName)) {
                    maxSearchQueries = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allow_partial_result".equals(fieldName)) {
                    allowPartialResult = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("include_contexts".equals(fieldName)) {
                    includeContexts = reader.readArray(reader1 -> OnYourDataContextProperty.fromString(reader1.getString()));
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    authentication = OnYourDataUsernameAndPasswordAuthenticationOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            MongoDBChatExtensionParameters deserializedMongoDBChatExtensionParameters = new MongoDBChatExtensionParameters(endpoint, collectionName, databaseName, appName, indexName, fieldsMapping, embeddingDependency);
            deserializedMongoDBChatExtensionParameters.topNDocuments = topNDocuments;
            deserializedMongoDBChatExtensionParameters.inScope = inScope;
            deserializedMongoDBChatExtensionParameters.strictness = strictness;
            deserializedMongoDBChatExtensionParameters.maxSearchQueries = maxSearchQueries;
            deserializedMongoDBChatExtensionParameters.allowPartialResult = allowPartialResult;
            deserializedMongoDBChatExtensionParameters.includeContexts = includeContexts;
            deserializedMongoDBChatExtensionParameters.authentication = authentication;
            return deserializedMongoDBChatExtensionParameters;
        });
    }

    public MongoDBChatExtensionParameters(String endpoint, String collectionName, String databaseName, String appName, String indexName, MongoDBChatExtensionParametersFieldsMapping fieldsMapping, BinaryData embeddingDependency) {
        this.endpoint = endpoint;
        this.collectionName = collectionName;
        this.databaseName = databaseName;
        this.appName = appName;
        this.indexName = indexName;
        this.fieldsMapping = fieldsMapping;
        this.embeddingDependency = embeddingDependency;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public MongoDBChatExtensionParameters setAuthentication(OnYourDataUsernameAndPasswordAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }
}

