/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OnYourDataAuthenticationOptions;
import com.azure.ai.openai.models.OnYourDataAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OnYourDataAccessTokenAuthenticationOptions
extends OnYourDataAuthenticationOptions {
    private final String accessToken;
    private OnYourDataAuthenticationType type = OnYourDataAuthenticationType.ACCESS_TOKEN;

    public OnYourDataAccessTokenAuthenticationOptions(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public OnYourDataAuthenticationType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("access_token", this.accessToken);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static OnYourDataAccessTokenAuthenticationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String accessToken = null;
            OnYourDataAuthenticationType type = OnYourDataAuthenticationType.ACCESS_TOKEN;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("access_token".equals(fieldName)) {
                    accessToken = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = OnYourDataAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            OnYourDataAccessTokenAuthenticationOptions deserializedOnYourDataAccessTokenAuthenticationOptions = new OnYourDataAccessTokenAuthenticationOptions(accessToken);
            deserializedOnYourDataAccessTokenAuthenticationOptions.type = type;
            return deserializedOnYourDataAccessTokenAuthenticationOptions;
        });
    }
}

