/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OnYourDataAuthenticationOptions;
import com.azure.ai.openai.models.OnYourDataAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OnYourDataConnectionStringAuthenticationOptions
extends OnYourDataAuthenticationOptions {
    private final String connectionString;
    private OnYourDataAuthenticationType type = OnYourDataAuthenticationType.CONNECTION_STRING;

    public OnYourDataConnectionStringAuthenticationOptions(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    @Override
    public OnYourDataAuthenticationType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connection_string", this.connectionString);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static OnYourDataConnectionStringAuthenticationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String connectionString = null;
            OnYourDataAuthenticationType type = OnYourDataAuthenticationType.CONNECTION_STRING;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connection_string".equals(fieldName)) {
                    connectionString = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = OnYourDataAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            OnYourDataConnectionStringAuthenticationOptions deserializedOnYourDataConnectionStringAuthenticationOptions = new OnYourDataConnectionStringAuthenticationOptions(connectionString);
            deserializedOnYourDataConnectionStringAuthenticationOptions.type = type;
            return deserializedOnYourDataConnectionStringAuthenticationOptions;
        });
    }
}

