/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OnYourDataAuthenticationOptions;
import com.azure.ai.openai.models.OnYourDataAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OnYourDataKeyAndKeyIdAuthenticationOptions
extends OnYourDataAuthenticationOptions {
    private final String key;
    private final String keyId;
    private OnYourDataAuthenticationType type = OnYourDataAuthenticationType.KEY_AND_KEY_ID;

    public OnYourDataKeyAndKeyIdAuthenticationOptions(String key, String keyId) {
        this.key = key;
        this.keyId = keyId;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyId() {
        return this.keyId;
    }

    @Override
    public OnYourDataAuthenticationType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("key_id", this.keyId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static OnYourDataKeyAndKeyIdAuthenticationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String key = null;
            String keyId = null;
            OnYourDataAuthenticationType type = OnYourDataAuthenticationType.KEY_AND_KEY_ID;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    key = reader.getString();
                    continue;
                }
                if ("key_id".equals(fieldName)) {
                    keyId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = OnYourDataAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            OnYourDataKeyAndKeyIdAuthenticationOptions deserializedOnYourDataKeyAndKeyIdAuthenticationOptions = new OnYourDataKeyAndKeyIdAuthenticationOptions(key, keyId);
            deserializedOnYourDataKeyAndKeyIdAuthenticationOptions.type = type;
            return deserializedOnYourDataKeyAndKeyIdAuthenticationOptions;
        });
    }
}

