/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OnYourDataAuthenticationOptions;
import com.azure.ai.openai.models.OnYourDataAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OnYourDataUsernameAndPasswordAuthenticationOptions
extends OnYourDataAuthenticationOptions {
    private OnYourDataAuthenticationType type = OnYourDataAuthenticationType.USERNAME_AND_PASSWORD;
    private final String username;
    private final String password;

    public OnYourDataUsernameAndPasswordAuthenticationOptions(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public OnYourDataAuthenticationType getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static OnYourDataUsernameAndPasswordAuthenticationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String username = null;
            String password = null;
            OnYourDataAuthenticationType type = OnYourDataAuthenticationType.USERNAME_AND_PASSWORD;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("username".equals(fieldName)) {
                    username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    password = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = OnYourDataAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            OnYourDataUsernameAndPasswordAuthenticationOptions deserializedOnYourDataUsernameAndPasswordAuthenticationOptions = new OnYourDataUsernameAndPasswordAuthenticationOptions(username, password);
            deserializedOnYourDataUsernameAndPasswordAuthenticationOptions.type = type;
            return deserializedOnYourDataUsernameAndPasswordAuthenticationOptions;
        });
    }
}

