/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class UploadPart
implements JsonSerializable<UploadPart> {
    private final String id;
    private final long createdAt;
    private final String uploadId;
    private final String object = "upload.part";
    private String azureBlockId;

    private UploadPart(String id, OffsetDateTime createdAt, String uploadId) {
        this.id = id;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.uploadId = uploadId;
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public String getObject() {
        return this.object;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("upload_id", this.uploadId);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeStringField("azure_block_id", this.azureBlockId);
        return jsonWriter.writeEndObject();
    }

    public static UploadPart fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String uploadId = null;
            String azureBlockId = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("upload_id".equals(fieldName)) {
                    uploadId = reader.getString();
                    continue;
                }
                if ("azure_block_id".equals(fieldName)) {
                    azureBlockId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            UploadPart deserializedUploadPart = new UploadPart(id, createdAt, uploadId);
            deserializedUploadPart.azureBlockId = azureBlockId;
            return deserializedUploadPart;
        });
    }

    public String getAzureBlockId() {
        return this.azureBlockId;
    }
}

